/*
 * Decompiled with CFR 0.152.
 */
package net.tinyallies.entity;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.tinyallies.entity.BabyMonster;
import net.tinyallies.entity.ai.LookForParentGoal;
import org.jetbrains.annotations.Nullable;

public class Creepy
extends Creeper
implements NeutralMob,
BabyMonster {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Creepy.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(Creepy.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDimensions STANDING = EntityDimensions.m_20395_((float)0.33f, (float)0.85f);
    private static final Map<Pose, EntityDimensions> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING).put((Object)Pose.SITTING, (Object)EntityDimensions.m_20395_((float)0.33f, (float)0.75f)).build();
    private final AvoidEntityGoal<Player> avoidPlayersGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 0.8, 1.33);
    private final LookForParentGoal followParentGoal = new LookForParentGoal((Mob)this, 1.0, this.getParentClass());
    private final NearestAttackableTargetGoal<Player> targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
    private boolean recentlyPopped;
    private boolean orderedToSit;
    @Nullable
    private LivingEntity parent;
    private int twinkleTime;

    public Creepy(EntityType<? extends Creeper> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.reassessTameGoals();
        this.applyAttributeModifiers();
    }

    public static float creepySeenPercent(Vec3 pExplosionVector, Entity pEntity) {
        AABB aabb = pEntity.m_20191_();
        double d0 = 1.0 / ((aabb.f_82291_ - aabb.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((aabb.f_82292_ - aabb.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((aabb.f_82293_ - aabb.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = Mth.m_14139_((double)d5, (double)aabb.f_82288_, (double)aabb.f_82291_);
                        double d9 = Mth.m_14139_((double)d6, (double)aabb.f_82289_, (double)aabb.f_82292_);
                        double d10 = Mth.m_14139_((double)d7, (double)aabb.f_82290_, (double)aabb.f_82293_);
                        Vec3 vec3 = new Vec3(d8 + d3, d9, d10 + d4);
                        if (pEntity.m_9236_().m_45547_(new ClipContext(vec3, pExplosionVector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, pEntity)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new BabySwellGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.defaultBabyGoals((PathfinderMob)this);
    }

    @Override
    public void reassessTameGoals() {
        this.f_21345_.m_25363_((Goal)this.followParentGoal);
        this.f_21345_.m_25363_(this.avoidPlayersGoal);
        this.f_21345_.m_25363_(this.targetPlayerGoal);
        if (!this.isTamed()) {
            if (this.getParent() == null) {
                this.f_21345_.m_25352_(4, this.avoidPlayersGoal);
            } else {
                this.f_21345_.m_25352_(0, (Goal)this.followParentGoal);
                this.f_21346_.m_25352_(3, this.targetPlayerGoal);
            }
        }
    }

    public boolean m_6673_(DamageSource pSource) {
        return this.hasSameOwner(pSource.m_7639_()) || super.m_6673_(pSource);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return pPose == Pose.SITTING ? 0.68f : 0.8f;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return POSES.getOrDefault(pPose, STANDING);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Items.f_42555_);
    }

    protected void m_6119_() {
        if (this.m_21524_() != null && this.isInSittingPose()) {
            if (this.m_20270_(this.m_21524_()) > 10.0f) {
                this.m_21455_(true, true);
            }
            return;
        }
        super.m_6119_();
    }

    public void m_32315_() {
        if (!this.m_9236_().f_46443_) {
            this.explode(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7090_() ? 2.0f : 1.0f);
            this.finalizeExplosion();
            if (this.m_7090_()) {
                this.m_146870_();
            } else {
                this.m_6469_(this.m_269291_().m_269264_(), 1.0f);
            }
            this.m_32316_();
            this.f_20890_ = true;
        }
    }

    public void explode(double x, double y, double z, float radius) {
        float f2 = radius * 2.0f;
        int k1 = Mth.m_14107_((double)(x - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(z + (double)f2 + 1.0));
        List list = this.m_9236_().m_45933_((Entity)this, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        Vec3 vec3 = new Vec3(x, y, z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d11;
            LivingEntity living;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_() || !((d12 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2) <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - y) * d7 + (d9 = entity.m_20189_() - z) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = Creepy.creepySeenPercent(vec3, entity);
            double d10 = (1.0 - d12) * d14;
            double v = (d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0;
            if (!(entity instanceof LivingEntity) || !this.babyWantsToAttack(living = (LivingEntity)entity, this.getOwner())) {
                entity.m_6469_(this.m_269291_().m_269036_(null, (Entity)this), (float)((int)v));
            } else {
                entity.m_6469_(this.m_269291_().m_269036_(null, (Entity)this), (float)((int)v));
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)livingentity, (double)d10);
            } else {
                d11 = d10;
            }
            Vec3 vec31 = new Vec3(d5 *= d11, d7 *= d11, d9 *= d11);
            entity.m_20256_(entity.m_20184_().m_82549_(vec31));
        }
    }

    private void finalizeExplosion() {
        if (this.m_217043_().m_188503_(5) == 4) {
            this.m_216990_(SoundEvents.f_11934_);
            this.twinkleTime = 10;
        } else {
            this.m_216990_(this.f_19796_.m_188499_() ? SoundEvents.f_11930_ : SoundEvents.f_11928_);
            this.m_9236_().m_7605_((Entity)this, (byte)101);
            this.twinkleTime = 2;
        }
    }

    public void setPowered(boolean b) {
        this.f_19804_.m_135381_(f_32274_, (Object)b);
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.m_150930_(Items.f_42403_);
    }

    @Override
    @Nullable
    public LivingEntity getParent() {
        return this.parent;
    }

    @Override
    public void setParent(LivingEntity living) {
        this.parent = living;
    }

    @Override
    public Class<? extends PathfinderMob> getParentClass() {
        return Creeper.class;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.m_32283_(0);
        return this.babyHurt((LivingEntity)this, pSource, super.m_6469_(pSource, pAmount));
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return this.babyInteract(pPlayer, pHand, super.m_6071_(pPlayer, pHand));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addBabySaveData(pCompound, this.orderedToSit);
        pCompound.m_128379_("Sitting", this.orderedToSit);
        this.m_21678_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readBabySaveData(pCompound, (LivingEntity)this);
        this.orderedToSit = pCompound.m_128471_("Sitting");
        this.setInSittingPose(this.orderedToSit);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public boolean m_6573_(Player pPlayer) {
        return !this.m_21523_() && pPlayer == this.getOwner();
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        this.handleBabyEvent(pId);
        if (pId == 101) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        } else if (pId == 100) {
            for (int i = 0; i < this.m_217043_().m_188503_(5) + 2; ++i) {
                double d0 = this.m_217043_().m_188583_() * 0.05;
                double d1 = this.m_217043_().m_188583_() * 0.05;
                double d2 = this.m_217043_().m_188583_() * 0.05;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20208_(2.0), this.m_20187_() + 0.5, this.m_20262_(2.0), d0, d1, d2);
            }
        }
    }

    public void m_8119_() {
        if (this.getParent() != null && !this.getParent().m_6084_()) {
            this.setParent(null);
            this.reassessTameGoals();
        }
        if (this.twinkleTime-- > 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)100);
        }
        if (this.f_32270_ >= 30) {
            this.m_32315_();
            this.f_32270_ = 0;
        }
        this.updatePose((LivingEntity)this);
        super.m_8119_();
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int pRemainingPersistentAngerTime) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID pPersistentAngerTarget) {
    }

    public void m_6825_() {
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        return !this.hasSameOwner((Entity)livingEntity) && super.m_6779_(livingEntity);
    }

    public Team m_5647_() {
        return this.getBabyTeam(super.m_5647_());
    }

    public boolean m_7307_(Entity pEntity) {
        return this.babyIsAlliedTo(pEntity, super.m_7307_(pEntity));
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        if (this.f_20890_) {
            this.sendDeathMessage((PathfinderMob)this);
        }
    }

    public boolean m_6935_(Player pPlayer) {
        return !this.isTamed();
    }

    @Override
    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    @Override
    public void setOrderedToSit(boolean pOrderedToSit) {
        this.orderedToSit = pOrderedToSit;
    }

    @Override
    public boolean isTamed() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    @Override
    public void setTamed(boolean pTamed) {
        byte flagsID = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(pTamed ? (byte)(flagsID | 4) : (byte)(flagsID & 0xFFFFFFFF)));
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    @Override
    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(pUuid));
    }

    @Override
    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    @Override
    public void setInSittingPose(boolean pSitting) {
        byte flagsID = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(pSitting ? (byte)(flagsID | 1) : (byte)(flagsID & 0xFFFFFFFE)));
    }

    static class BabySwellGoal
    extends Goal {
        private final Creepy creeper;
        @Nullable
        private LivingEntity target;

        public BabySwellGoal(Creepy pCreeper) {
            this.creeper = pCreeper;
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.creeper.m_5448_();
            return this.creeper.m_32310_() > 0 || livingentity != null && this.creeper.m_20280_((Entity)livingentity) < 4.0 && !this.creeper.recentlyPopped;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && this.creeper.m_20280_((Entity)this.target) < 4.0 && !this.creeper.recentlyPopped;
        }

        public void m_8056_() {
            this.target = this.creeper.m_5448_();
        }

        public void m_8041_() {
            this.target = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.creeper.m_32283_(-1);
            } else if (this.creeper.m_20280_((Entity)this.target) > 49.0) {
                this.creeper.m_32283_(-1);
            } else if (!this.creeper.m_21574_().m_148306_((Entity)this.target)) {
                this.creeper.m_32283_(-1);
            } else {
                this.creeper.m_32283_(1);
            }
        }
    }
}

