/*
 * Decompiled with CFR 0.152.
 */
package net.tinyallies.entity;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.scores.Team;
import net.tinyallies.entity.EnderBoy;
import net.tinyallies.entity.Zomby;
import net.tinyallies.entity.ai.BabyFleeSunGoal;
import net.tinyallies.entity.ai.DefendOwnerTargetGoal;
import net.tinyallies.entity.ai.FollowOwnerGoal;
import net.tinyallies.entity.ai.HelpOwnerTargetGoal;
import net.tinyallies.entity.ai.SitWhenOrderedToGoal;
import org.jetbrains.annotations.NotNull;

public interface BabyMonster {
    public static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836"), "Speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    public static final AttributeModifier DAMAGE_MODIFIER = new AttributeModifier(UUID.fromString("1eaf83ff-7207-4596-b37a-d7297b3ec4ce"), "Damage nerf", -0.25, AttributeModifier.Operation.MULTIPLY_BASE);

    @NotNull
    private PathfinderMob getAsMob() {
        return (PathfinderMob)this;
    }

    @NotNull
    private NeutralMob getAsNeutral() {
        return (NeutralMob)this;
    }

    default public void applyAttributeModifiers() {
        if (!(this instanceof Zomby)) {
            AttributeInstance speedInstance = this.getAsMob().m_21051_(Attributes.f_22279_);
            speedInstance.m_22118_(SPEED_MODIFIER);
        }
        AttributeInstance damageInstance = this.getAsMob().m_21051_(Attributes.f_22281_);
        damageInstance.m_22118_(DAMAGE_MODIFIER);
    }

    default public boolean isUndead() {
        return false;
    }

    default public boolean canBeTamed() {
        return this.getParent() == null;
    }

    default public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        return uuid == null ? null : this.getAsMob().m_9236_().m_46003_(uuid);
    }

    default public boolean isOwnedBy(Entity pEntity) {
        return pEntity == this.getOwner();
    }

    default public boolean hasSameOwner(Entity pEntity) {
        BabyMonster baby;
        return pEntity instanceof BabyMonster && (baby = (BabyMonster)pEntity).getOwner() == this.getOwner();
    }

    default public void tame(Player pPlayer) {
        this.setTamed(true);
        this.setOwnerUUID(pPlayer.m_20148_());
        this.setParent(null);
        this.getAsMob().m_21530_();
        this.reassessTameGoals();
    }

    default public void defaultBabyGoals(PathfinderMob entity) {
        if (this.isUndead()) {
            entity.f_21345_.m_25352_(1, (Goal)new BabyFleeSunGoal(entity, 1.0));
            entity.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal(entity));
        } else if (!(entity instanceof EnderBoy)) {
            entity.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal(entity, 1.0));
        }
        entity.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal(entity, 1.0, 12.0f, 3.0f, false));
        entity.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)entity));
        entity.f_21345_.m_25352_(5, (Goal)new SitWhenOrderedToGoal(entity));
        entity.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)entity, Player.class, 8.0f));
        entity.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)entity));
        entity.f_21346_.m_25352_(0, (Goal)new HelpOwnerTargetGoal(entity));
        entity.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(entity, new Class[0]));
        entity.f_21346_.m_25352_(2, (Goal)new DefendOwnerTargetGoal(entity));
    }

    default public InteractionResult babyInteract(Player pPlayer, InteractionHand pHand, InteractionResult pSuper) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        PathfinderMob mob = this.getAsMob();
        NeutralMob neutral = this.getAsNeutral();
        if (mob.m_9236_().f_46443_) {
            boolean canInteract = this.isOwnedBy((Entity)pPlayer) || this.isTamed() || this.isFood(itemstack) && !this.isTamed() && !neutral.m_21660_();
            return canInteract ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTamed() && this.isOwnedBy((Entity)pPlayer)) {
            if (this.isFood(itemstack) && mob.m_21223_() < mob.m_21233_()) {
                mob.m_5634_(4.0f);
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                mob.m_146852_(GameEvent.f_157806_, (Entity)mob);
                mob.m_216990_(SoundEvents.f_144165_);
                if (mob.m_21223_() == mob.m_21233_()) {
                    mob.m_9236_().m_7605_((Entity)mob, (byte)7);
                }
                return InteractionResult.SUCCESS;
            }
            if (!pSuper.m_19077_() && this.isOwnedBy((Entity)pPlayer) && !pPlayer.m_6047_()) {
                this.setOrderedToSit(!this.isOrderedToSit());
                mob.m_6862_(false);
                mob.m_21573_().m_5624_((Entity)mob, 0.0);
                mob.m_21573_().m_26573_();
                neutral.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return pSuper;
        }
        if (this.isFood(itemstack) && !neutral.m_21660_() && this.canBeTamed()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (mob.m_217043_().m_188503_(3) == 0) {
                this.tame(pPlayer);
                mob.m_21573_().m_26573_();
                neutral.m_6710_(null);
                this.setOrderedToSit(true);
                mob.m_9236_().m_7605_((Entity)mob, (byte)7);
            } else {
                mob.m_9236_().m_7605_((Entity)mob, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return pSuper;
    }

    default public void addBabySaveData(CompoundTag pCompound, boolean orderedToSit) {
        if (this.getOwnerUUID() != null) {
            pCompound.m_128362_("Parent", this.getOwnerUUID());
        }
        pCompound.m_128379_("Sitting", orderedToSit);
    }

    default public void readBabySaveData(CompoundTag pCompound, LivingEntity entity) {
        UUID uuid;
        UUID uUID = uuid = pCompound.m_128403_("Parent") ? pCompound.m_128342_("Parent") : OldUsersConverter.m_11083_((MinecraftServer)entity.m_20194_(), (String)pCompound.m_128461_("Parent"));
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTamed(true);
            }
            catch (Throwable throwable) {
                this.setTamed(false);
            }
        }
    }

    default public void spawnTamingParticles(boolean pTamed) {
        PathfinderMob entity = this.getAsMob();
        SimpleParticleType particleOptions = !pTamed ? ParticleTypes.f_123762_ : (this.isUndead() ? ParticleTypes.f_123798_ : ParticleTypes.f_123750_);
        for (int i = 0; i < 7; ++i) {
            double d0 = entity.m_217043_().m_188583_() * 0.02;
            double d1 = entity.m_217043_().m_188583_() * 0.02;
            double d2 = entity.m_217043_().m_188583_() * 0.02;
            entity.m_9236_().m_7106_((ParticleOptions)particleOptions, entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
        }
    }

    default public boolean babyWantsToAttack(LivingEntity pTarget, LivingEntity pOwner) {
        if (pTarget instanceof OwnableEntity) {
            return ((OwnableEntity)pTarget).m_269323_() != pOwner;
        }
        if (pTarget instanceof BabyMonster) {
            return !this.hasSameOwner((Entity)pTarget);
        }
        return true;
    }

    default public void handleBabyEvent(byte pId) {
        if (pId == 7) {
            this.spawnTamingParticles(true);
        } else if (pId == 6) {
            this.spawnTamingParticles(false);
        }
    }

    default public void updatePose(LivingEntity pTarget) {
        pTarget.m_20124_(this.isInSittingPose() ? Pose.SITTING : Pose.STANDING);
    }

    default public boolean babyHurt(LivingEntity livingEntity, DamageSource pSource, boolean b) {
        if (!livingEntity.m_6673_(pSource) && !livingEntity.m_9236_().f_46443_) {
            ((BabyMonster)livingEntity).setOrderedToSit(false);
        }
        return b;
    }

    default public void sendDeathMessage(PathfinderMob entity) {
        LivingEntity owner;
        Component deathMessage = entity.m_21231_().m_19293_();
        if (!entity.m_9236_().f_46443_ && entity.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && (owner = ((BabyMonster)entity).getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            if (entity.m_21232_() != owner && entity.m_5448_() != null) {
                int randomMessageIndex = entity.m_217043_().m_188503_(10);
                MutableComponent deathMessageCopy = deathMessage.m_6881_().m_7220_((Component)Component.m_237110_((String)("death_msg." + randomMessageIndex), (Object[])new Object[]{owner.m_7755_()}));
                serverPlayer.m_213846_((Component)deathMessageCopy);
            } else {
                serverPlayer.m_213846_(deathMessage);
            }
        }
    }

    default public Team getBabyTeam(Team pSuper) {
        LivingEntity owner = this.getOwner();
        if (this.isTamed() && owner != null) {
            return owner.m_5647_();
        }
        return pSuper;
    }

    default public boolean babyIsAlliedTo(Entity pEntity, boolean pSuper) {
        if (this.isTamed()) {
            LivingEntity owner = this.getOwner();
            return owner != null && (pEntity == owner || owner.m_7307_(pEntity));
        }
        return pSuper;
    }

    public Class<? extends PathfinderMob> getParentClass();

    public LivingEntity getParent();

    public void setParent(LivingEntity var1);

    public boolean isFood(ItemStack var1);

    public boolean isTamed();

    public void setTamed(boolean var1);

    public void reassessTameGoals();

    public UUID getOwnerUUID();

    public void setOwnerUUID(UUID var1);

    public boolean isOrderedToSit();

    public void setOrderedToSit(boolean var1);

    public boolean isInSittingPose();

    public void setInSittingPose(boolean var1);
}

