/*
 * Decompiled with CFR 0.152.
 */
package net.tinyallies.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.tinyallies.client.layer.CreepyPowerLayer;
import net.tinyallies.client.model.CreepyModel;
import net.tinyallies.entity.Creepy;

public class CreepyRenderer
extends MobRenderer<Creepy, CreepyModel> {
    private static final ResourceLocation CREEPER_LOCATION = new ResourceLocation("textures/entity/creeper/creeper.png");

    public CreepyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CreepyModel(context.m_174023_(ModelLayers.f_171285_)), 0.25f);
        this.m_115326_((RenderLayer)new CreepyPowerLayer((RenderLayerParent<Creepy, CreepyModel>)this, context.m_174027_()));
    }

    protected void scale(Creepy pLivingEntity, PoseStack pMatrixStack, float pPartialTickTime) {
        float f = pLivingEntity.m_32320_(pPartialTickTime);
        float f1 = 1.0f + Mth.m_14031_((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        pMatrixStack.m_85841_(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(Creepy pLivingEntity, float pPartialTicks) {
        float f = pLivingEntity.m_32320_(pPartialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)f, (float)0.5f, (float)1.0f);
    }

    public Vec3 getRenderOffset(Creepy entity, float f) {
        return entity.isInSittingPose() ? new Vec3(0.0, -0.126, 0.0) : super.m_7860_((Entity)entity, f);
    }

    public ResourceLocation getTextureLocation(Creepy pEntity) {
        return CREEPER_LOCATION;
    }
}

