/*
 * Decompiled with CFR 0.152.
 */
package net.tinyallies.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.tinyallies.entity.Creepy;
import net.tinyallies.util.ModUtil;

public class CreepyModel
extends CreeperModel<Creepy> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private boolean shouldOffsetLegs;

    public CreepyModel(ModelPart pRoot) {
        super(pRoot);
        this.head = pRoot.m_171324_("head");
        this.body = pRoot.m_171324_("body");
        this.leftHindLeg = pRoot.m_171324_("right_hind_leg");
        this.rightHindLeg = pRoot.m_171324_("left_hind_leg");
        this.leftFrontLeg = pRoot.m_171324_("right_front_leg");
        this.rightFrontLeg = pRoot.m_171324_("left_front_leg");
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        ModUtil.babyfyModel(this.headParts(), this.bodyParts(), 14.0f, 0.0f, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
        float frontLegsOffset = this.shouldOffsetLegs ? 0.13f : 0.0f;
        pPoseStack.m_252880_(0.0f, 1.5f, 0.0f + frontLegsOffset);
        this.frontLegs().forEach(modelPart -> modelPart.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
        pPoseStack.m_85849_();
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg);
    }

    protected Iterable<ModelPart> frontLegs() {
        return ImmutableList.of((Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }

    public void setupAnim(Creepy pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.m_6973_((Entity)pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        if (pEntity.isInSittingPose()) {
            this.rightFrontLeg.f_104203_ = -1.5707964f;
            this.leftFrontLeg.f_104203_ = -1.5707964f;
            this.rightHindLeg.f_104203_ = -1.565f;
            this.rightHindLeg.f_104204_ = -0.7853982f;
            this.leftHindLeg.f_104203_ = -1.565f;
            this.leftHindLeg.f_104204_ = 0.7853982f;
            this.shouldOffsetLegs = true;
        } else {
            this.shouldOffsetLegs = false;
            float f = 1.0f;
            if (pEntity.m_21256_() > 4) {
                f = (float)pEntity.m_20184_().m_82556_();
                f /= 0.2f;
                f *= f * f;
            }
            if (f < 1.0f) {
                f = 1.0f;
            }
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount / f;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount / f;
            this.rightHindLeg.f_104204_ = 0.005f;
            this.leftHindLeg.f_104204_ = -0.005f;
            this.rightHindLeg.f_104205_ = 0.005f;
            this.leftHindLeg.f_104205_ = -0.005f;
        }
    }
}

