/*
 * Decompiled with CFR 0.152.
 */
package net.tinyallies.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.tinyallies.entity.BabyMonster;

public class BabyHeldItemLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandRenderer itemInHandRenderer;

    public BabyHeldItemLayer(RenderLayerParent<T, M> pRenderer, ItemInHandRenderer pItemInHandRenderer) {
        super(pRenderer);
        this.itemInHandRenderer = pItemInHandRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ItemStack rightHandItem;
        boolean isRightHanded = pLivingEntity.m_5737_() == HumanoidArm.RIGHT;
        ItemStack leftHandItem = isRightHanded ? pLivingEntity.m_21206_() : pLivingEntity.m_21205_();
        ItemStack itemStack = rightHandItem = isRightHanded ? pLivingEntity.m_21205_() : pLivingEntity.m_21206_();
        if (!(leftHandItem.m_41619_() && rightHandItem.m_41619_() || !(pLivingEntity instanceof BabyMonster))) {
            BabyMonster baby = (BabyMonster)pLivingEntity;
            poseStack.m_85836_();
            float offsetX = rightHandItem.m_41720_() instanceof BowItem ? 0.03f : 0.11f;
            poseStack.m_85837_((double)offsetX, 0.75, 0.0);
            this.renderArmWithItem((LivingEntity)pLivingEntity, rightHandItem, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, pBuffer, pPackedLight);
            this.renderArmWithItem((LivingEntity)pLivingEntity, leftHandItem, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, pBuffer, pPackedLight);
            poseStack.m_85849_();
        }
    }

    protected void renderArmWithItem(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext context, HumanoidArm hand, PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (!itemStack.m_41619_()) {
            BabyMonster baby;
            if (itemStack.m_41720_() instanceof BowItem && livingEntity instanceof BabyMonster && (baby = (BabyMonster)livingEntity).isInSittingPose()) {
                poseStack.m_85836_();
                boolean flag = hand == HumanoidArm.LEFT;
                poseStack.m_252781_(Axis.f_252403_.m_252977_(80.0f));
                poseStack.m_252880_(0.355f, 0.0f, 0.35f);
                poseStack.m_252880_(0.0f, 0.195f, -0.625f);
                this.itemInHandRenderer.m_269530_(livingEntity, itemStack, context, flag, poseStack, pBuffer, pPackedLight);
                poseStack.m_85849_();
            } else {
                poseStack.m_85836_();
                ((ArmedModel)this.m_117386_()).m_6002_(hand, poseStack);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                boolean isLeftHand = hand == HumanoidArm.LEFT;
                poseStack.m_252880_((float)(isLeftHand ? -1 : 1) / 16.0f, 0.125f, -0.625f);
                poseStack.m_252880_(-0.075f, 0.0f, 0.35f);
                this.itemInHandRenderer.m_269530_(livingEntity, itemStack, context, isLeftHand, poseStack, pBuffer, pPackedLight);
                poseStack.m_85849_();
            }
        }
    }
}

