/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.mixin;

import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.item.PearlNecklaceItem;
import com.github.eterdelta.crittersandcompanions.item.SilkLeashItem;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundSilkLeashStatePacket;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import com.github.eterdelta.crittersandcompanions.registry.CACBlocks;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ISilkLeashState {
    @Unique
    private final Pair<Set<UUID>, Set<UUID>> savedLeashState = new ObjectObjectImmutablePair(new HashSet(), new HashSet());
    @Unique
    private boolean needsLeashStateLoad;
    @Unique
    private int leashStateLoadDelay;
    @Unique
    private final Set<LivingEntity> leashingEntities = new HashSet<LivingEntity>();
    @Unique
    private final Set<LivingEntity> leashedByEntities = new HashSet<LivingEntity>();

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void onAddAdditionalSaveData(CompoundTag compoundTag, CallbackInfo callbackInfo) {
        if (!this.m_9236_().m_5776_()) {
            ListTag leashingEntitiesList = new ListTag();
            for (Entity entity : this.getLeashingEntities()) {
                leashingEntitiesList.add((Object)NbtUtils.m_129226_((UUID)entity.m_20148_()));
            }
            compoundTag.m_128365_("LeashingEntities", (Tag)leashingEntitiesList);
            ListTag leashedByEntitiesList = new ListTag();
            for (Entity entity : this.getLeashedByEntities()) {
                leashedByEntitiesList.add((Object)NbtUtils.m_129226_((UUID)entity.m_20148_()));
            }
            compoundTag.m_128365_("LeashedByEntities", (Tag)leashedByEntitiesList);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void onReadAdditionalSaveData(CompoundTag compoundTag, CallbackInfo callbackInfo) {
        if (!this.m_9236_().m_5776_()) {
            ListTag leashingEntitiesList = compoundTag.m_128437_("LeashingEntities", 11);
            for (Tag tag : leashingEntitiesList) {
                UUID uuid = NbtUtils.m_129233_((Tag)tag);
                ((Set)this.savedLeashState.first()).add(uuid);
            }
            ListTag leashedByEntitiesList = compoundTag.m_128437_("LeashedByEntities", 11);
            for (Tag tag : leashedByEntitiesList) {
                UUID uuid = NbtUtils.m_129233_((Tag)tag);
                ((Set)this.savedLeashState.second()).add(uuid);
            }
            if (!leashingEntitiesList.isEmpty() || !leashedByEntitiesList.isEmpty()) {
                this.needsLeashStateLoad = true;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void onTick(CallbackInfo callbackInfo) {
        if (!this.m_9236_().m_5776_()) {
            if (this.needsLeashStateLoad) {
                ++this.leashStateLoadDelay;
                if (this.leashStateLoadDelay >= 20) {
                    LivingEntity entity;
                    Set<LivingEntity> leashingEntities = this.getLeashingEntities();
                    Set<LivingEntity> leashedByEntities = this.getLeashedByEntities();
                    for (UUID uuid : (Set)this.savedLeashState.first()) {
                        entity = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(uuid);
                        if (entity == null) continue;
                        leashingEntities.add(entity);
                    }
                    ((Set)this.savedLeashState.first()).clear();
                    for (UUID uuid : (Set)this.savedLeashState.second()) {
                        entity = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(uuid);
                        if (entity == null) continue;
                        leashedByEntities.add(entity);
                    }
                    ((Set)this.savedLeashState.second()).clear();
                    this.sendLeashState();
                    this.needsLeashStateLoad = false;
                    this.leashStateLoadDelay = 0;
                }
            }
            int entitiesBefore = this.getLeashingEntities().size();
            this.getLeashingEntities().removeIf(leashedEntity -> {
                Vec3 distance = this.m_20182_().m_82546_(leashedEntity.m_20182_());
                double distanceSqr = distance.m_82556_();
                if (distanceSqr > 14.0) {
                    leashedEntity.m_20256_(leashedEntity.m_20184_().m_82549_(distance.m_82490_(0.1).m_82520_(0.0, 0.1, 0.0)));
                    if (distanceSqr > 28.0) {
                        ISilkLeashState leashedLeashState = (ISilkLeashState)leashedEntity;
                        leashedLeashState.getLeashedByEntities().remove(this);
                        leashedLeashState.sendLeashState();
                        return true;
                    }
                }
                return false;
            });
            int unleashedEntities = entitiesBefore - this.getLeashingEntities().size();
            if (unleashedEntities > 0) {
                ItemEntity leadEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)CACItems.SILK_LEAD.get(), unleashedEntities));
                this.m_9236_().m_7967_((Entity)leadEntity);
                this.sendLeashState();
            }
        }
    }

    @Inject(at={@At(value="INVOKE", target="net/minecraft/world/entity/LivingEntity.gameEvent(Lnet/minecraft/world/level/gameevent/GameEvent;)V", ordinal=0, shift=At.Shift.BY, by=1)}, method={"die"})
    private void onDie(DamageSource source, CallbackInfo callbackInfo) {
        int unleashedStates = 0;
        unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates((LivingEntity)this, null) - 1);
        if ((unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(null, (LivingEntity)this) - 1)) > 0) {
            ItemEntity leadEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)CACItems.SILK_LEAD.get(), unleashedStates));
            this.m_9236_().m_7967_((Entity)leadEntity);
        }
    }

    @Redirect(at=@At(value="INVOKE", target="net/minecraft/world/entity/LivingEntity.isInWater()Z"), method={"travel(Lnet/minecraft/world/phys/Vec3;)V"})
    private boolean redirectIsInWater(LivingEntity entity) {
        return this.m_20069_() || this.m_146900_().m_60713_((Block)CACBlocks.SEA_BUNNY_SLIME_BLOCK.get());
    }

    @ModifyVariable(at=@At(value="LOAD"), method={"aiStep()V"}, ordinal=0)
    private boolean modifyWaterFlag(boolean flag) {
        return flag || this.m_146900_().m_60713_((Block)CACBlocks.SEA_BUNNY_SLIME_BLOCK.get());
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;moveRelative(FLnet/minecraft/world/phys/Vec3;)V", ordinal=0))
    private float modifySwimSpeed(float original) {
        return PearlNecklaceItem.getWearing(this).map(PearlNecklaceItem::getLevel).map(level -> Float.valueOf(original + (float)((double)original * ((double)level.intValue() * (Double)Services.CONFIGS.common().necklaceSwimSpeed.get())))).orElse(Float.valueOf(original)).floatValue();
    }

    @Override
    public void sendLeashState() {
        CACPacketHandler.SILK_LEASH_STATE.sendToTracking(this, new ClientboundSilkLeashStatePacket(new ClientboundSilkLeashStatePacket.LeashData(this.m_19879_(), (IntList)new IntArrayList(this.getLeashingEntities().stream().mapToInt(Entity::m_19879_).toArray()), (IntList)new IntArrayList(this.getLeashedByEntities().stream().mapToInt(Entity::m_19879_).toArray()))));
    }

    @Override
    public Set<LivingEntity> getLeashingEntities() {
        return this.leashingEntities;
    }

    @Override
    public Set<LivingEntity> getLeashedByEntities() {
        return this.leashedByEntities;
    }
}

