/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.net;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.zeith.hammeranims.api.animsys.IAnimatedObject;
import org.zeith.hammeranims.api.particles.IParticleContainer;
import org.zeith.hammeranims.core.client.particle.ParticleWithEmitter;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.api.lighting.ColoredLightManager;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;

@MainThreaded
public class PacketPlayParticleEffectAtObject
implements IPacket {
    IObjectSource<?> source;
    ResourceLocation container;
    Matrix3f rotation;

    public PacketPlayParticleEffectAtObject(IAnimatedObject object, IParticleContainer particle) {
        this.source = object.getAnimationSource();
        this.container = particle.getRegistryKey();
    }

    public PacketPlayParticleEffectAtObject(IAnimatedObject object, ResourceLocation particle) {
        this.source = object.getAnimationSource();
        this.container = particle;
    }

    public PacketPlayParticleEffectAtObject(IAnimatedObject object, IParticleContainer particle, Matrix3f rotation) {
        this(object, particle);
        this.rotation = new Matrix3f((Matrix3fc)rotation);
    }

    public PacketPlayParticleEffectAtObject(IAnimatedObject object, ResourceLocation particle, Matrix3f rotation) {
        this(object, particle);
        this.rotation = new Matrix3f((Matrix3fc)rotation);
    }

    public PacketPlayParticleEffectAtObject() {
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130079_(IObjectSource.writeSource(this.source));
        buf.m_130085_(this.container);
        buf.writeBoolean(this.rotation != null);
        if (this.rotation != null) {
            buf.writeFloat(this.rotation.m00());
            buf.writeFloat(this.rotation.m01());
            buf.writeFloat(this.rotation.m02());
            buf.writeFloat(this.rotation.m10());
            buf.writeFloat(this.rotation.m11());
            buf.writeFloat(this.rotation.m12());
            buf.writeFloat(this.rotation.m20());
            buf.writeFloat(this.rotation.m21());
            buf.writeFloat(this.rotation.m22());
        }
    }

    public void read(FriendlyByteBuf buf) {
        this.source = IObjectSource.readSource((CompoundTag)buf.m_130260_()).orElse(null);
        this.container = buf.m_130281_();
        if (buf.readBoolean()) {
            this.rotation = new Matrix3f(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        ClientLevel cl;
        IParticleContainer container;
        block7: {
            block6: {
                Level level;
                if (this.source == null) {
                    return;
                }
                if (this.container == null) {
                    return;
                }
                container = IParticleContainer.byRegistryKey(this.container);
                Player player = ColoredLightManager.getClientPlayer();
                if (player == null || !((level = player.m_9236_()) instanceof ClientLevel)) break block6;
                cl = (ClientLevel)level;
                if (container != null) break block7;
            }
            return;
        }
        IAnimatedObject obj = this.source.get(IAnimatedObject.class, (Level)cl).orElse(null);
        if (obj == null) {
            return;
        }
        ParticleWithEmitter pwe = new ParticleWithEmitter(cl, obj, container);
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)pwe);
    }
}

