/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class GsonHelper {
    private static final Gson GSON = new GsonBuilder().create();

    public static Vector3f getAsVec3f(JsonObject parent, String memberName) {
        return GsonHelper.toVec3f(GsonHelper.getAsJsonArray(parent, memberName), memberName);
    }

    public static Vector3f getAsVec3f(JsonObject parent, String memberName, Vector3f defaultVal) {
        if (parent.has(memberName)) {
            return GsonHelper.getAsVec3f(parent, memberName);
        }
        return defaultVal;
    }

    public static Vector3f toVec3f(JsonArray array, String name) {
        if (array.size() != 3) {
            throw new JsonSyntaxException("Expected 3 elements in '" + name + "' array, found: " + array.size());
        }
        return new Vector3f(GsonHelper.convertToFloat(array.get(0), "member of '" + name + "'"), GsonHelper.convertToFloat(array.get(1), "member of '" + name + "'"), GsonHelper.convertToFloat(array.get(2), "member of '" + name + "'"));
    }

    public static Vector2f getAsVec2f(JsonObject parent, String memberName) {
        return GsonHelper.toVec2f(GsonHelper.getAsJsonArray(parent, memberName), memberName);
    }

    public static Vector2f getAsVec3f(JsonObject parent, String memberName, Vector2f defaultVal) {
        if (parent.has(memberName)) {
            return GsonHelper.getAsVec2f(parent, memberName);
        }
        return defaultVal;
    }

    public static Vector2f toVec2f(JsonArray array, String name) {
        if (array.size() != 2) {
            throw new JsonSyntaxException("Expected 2 elements in '" + name + "' array, found: " + array.size());
        }
        return new Vector2f(GsonHelper.convertToFloat(array.get(0), "member of '" + name + "'"), GsonHelper.convertToFloat(array.get(1), "member of '" + name + "'"));
    }

    public static boolean isStringValue(JsonObject pJson, String pMemberName) {
        return !GsonHelper.isValidPrimitive(pJson, pMemberName) ? false : pJson.getAsJsonPrimitive(pMemberName).isString();
    }

    public static boolean isStringValue(JsonElement pJson) {
        return !pJson.isJsonPrimitive() ? false : pJson.getAsJsonPrimitive().isString();
    }

    public static boolean isNumberValue(JsonObject pJson, String pMemberName) {
        return !GsonHelper.isValidPrimitive(pJson, pMemberName) ? false : pJson.getAsJsonPrimitive(pMemberName).isNumber();
    }

    public static boolean isNumberValue(JsonElement pJson) {
        return !pJson.isJsonPrimitive() ? false : pJson.getAsJsonPrimitive().isNumber();
    }

    public static boolean isBooleanValue(JsonObject pJson, String pMemberName) {
        return !GsonHelper.isValidPrimitive(pJson, pMemberName) ? false : pJson.getAsJsonPrimitive(pMemberName).isBoolean();
    }

    public static boolean isBooleanValue(JsonElement pJson) {
        return !pJson.isJsonPrimitive() ? false : pJson.getAsJsonPrimitive().isBoolean();
    }

    public static boolean isArrayNode(JsonObject pJson, String pMemberName) {
        return !GsonHelper.isValidNode(pJson, pMemberName) ? false : pJson.get(pMemberName).isJsonArray();
    }

    public static boolean isObjectNode(JsonObject pJson, String pMemberName) {
        return !GsonHelper.isValidNode(pJson, pMemberName) ? false : pJson.get(pMemberName).isJsonObject();
    }

    public static boolean isValidPrimitive(JsonObject pJson, String pMemberName) {
        return !GsonHelper.isValidNode(pJson, pMemberName) ? false : pJson.get(pMemberName).isJsonPrimitive();
    }

    public static boolean isValidNode(@Nullable JsonObject pJson, String pMemberName) {
        if (pJson == null) {
            return false;
        }
        return pJson.get(pMemberName) != null;
    }

    public static JsonElement getNonNull(JsonObject pJson, String pMemberName) {
        JsonElement jsonelement = pJson.get(pMemberName);
        if (jsonelement != null && !jsonelement.isJsonNull()) {
            return jsonelement;
        }
        throw new JsonSyntaxException("Missing field " + pMemberName);
    }

    public static String convertToString(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive()) {
            return pJson.getAsString();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a string, was " + GsonHelper.getType(pJson));
    }

    public static String getAsString(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToString(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a string");
    }

    @Nullable
    public static String getAsString(JsonObject pJson, String pMemberName, @Nullable String pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToString(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static boolean convertToBoolean(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive()) {
            return pJson.getAsBoolean();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a Boolean, was " + GsonHelper.getType(pJson));
    }

    public static boolean getAsBoolean(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToBoolean(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a Boolean");
    }

    public static boolean getAsBoolean(JsonObject pJson, String pMemberName, boolean pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToBoolean(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static double convertToDouble(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive() && pJson.getAsJsonPrimitive().isNumber()) {
            return pJson.getAsDouble();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a Double, was " + GsonHelper.getType(pJson));
    }

    public static double getAsDouble(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToDouble(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a Double");
    }

    public static double getAsDouble(JsonObject pJson, String pMemberName, double pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToDouble(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static float convertToFloat(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive() && pJson.getAsJsonPrimitive().isNumber()) {
            return pJson.getAsFloat();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a Float, was " + GsonHelper.getType(pJson));
    }

    public static float getAsFloat(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToFloat(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a Float");
    }

    public static float getAsFloat(JsonObject pJson, String pMemberName, float pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToFloat(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static long convertToLong(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive() && pJson.getAsJsonPrimitive().isNumber()) {
            return pJson.getAsLong();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a Long, was " + GsonHelper.getType(pJson));
    }

    public static long getAsLong(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToLong(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a Long");
    }

    public static long getAsLong(JsonObject pJson, String pMemberName, long pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToLong(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static int convertToInt(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive() && pJson.getAsJsonPrimitive().isNumber()) {
            return pJson.getAsInt();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a Int, was " + GsonHelper.getType(pJson));
    }

    public static int getAsInt(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToInt(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a Int");
    }

    public static int getAsInt(JsonObject pJson, String pMemberName, int pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToInt(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static byte convertToByte(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive() && pJson.getAsJsonPrimitive().isNumber()) {
            return pJson.getAsByte();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a Byte, was " + GsonHelper.getType(pJson));
    }

    public static byte getAsByte(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToByte(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a Byte");
    }

    public static byte getAsByte(JsonObject pJson, String pMemberName, byte pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToByte(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static char convertToCharacter(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive() && pJson.getAsJsonPrimitive().isNumber()) {
            return pJson.getAsCharacter();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a Character, was " + GsonHelper.getType(pJson));
    }

    public static char getAsCharacter(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToCharacter(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a Character");
    }

    public static char getAsCharacter(JsonObject pJson, String pMemberName, char pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToCharacter(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static BigDecimal convertToBigDecimal(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive() && pJson.getAsJsonPrimitive().isNumber()) {
            return pJson.getAsBigDecimal();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a BigDecimal, was " + GsonHelper.getType(pJson));
    }

    public static BigDecimal getAsBigDecimal(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToBigDecimal(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a BigDecimal");
    }

    public static BigDecimal getAsBigDecimal(JsonObject pJson, String pMemberName, BigDecimal pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToBigDecimal(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static BigInteger convertToBigInteger(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive() && pJson.getAsJsonPrimitive().isNumber()) {
            return pJson.getAsBigInteger();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a BigInteger, was " + GsonHelper.getType(pJson));
    }

    public static BigInteger getAsBigInteger(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToBigInteger(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a BigInteger");
    }

    public static BigInteger getAsBigInteger(JsonObject pJson, String pMemberName, BigInteger pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToBigInteger(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static short convertToShort(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonPrimitive() && pJson.getAsJsonPrimitive().isNumber()) {
            return pJson.getAsShort();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a Short, was " + GsonHelper.getType(pJson));
    }

    public static short getAsShort(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToShort(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a Short");
    }

    public static short getAsShort(JsonObject pJson, String pMemberName, short pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToShort(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static JsonObject convertToJsonObject(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonObject()) {
            return pJson.getAsJsonObject();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a JsonObject, was " + GsonHelper.getType(pJson));
    }

    public static JsonObject getAsJsonObject(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToJsonObject(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a JsonObject");
    }

    @Nullable
    public static JsonObject getAsJsonObject(JsonObject pJson, String pMemberName, @Nullable JsonObject pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToJsonObject(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static JsonArray convertToJsonArray(JsonElement pJson, String pMemberName) {
        if (pJson.isJsonArray()) {
            return pJson.getAsJsonArray();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be a JsonArray, was " + GsonHelper.getType(pJson));
    }

    public static JsonArray getAsJsonArray(JsonObject pJson, String pMemberName) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToJsonArray(pJson.get(pMemberName), pMemberName);
        }
        throw new JsonSyntaxException("Missing " + pMemberName + ", expected to find a JsonArray");
    }

    @Nullable
    public static JsonArray getAsJsonArray(JsonObject pJson, String pMemberName, @Nullable JsonArray pFallback) {
        return pJson.has(pMemberName) ? GsonHelper.convertToJsonArray(pJson.get(pMemberName), pMemberName) : pFallback;
    }

    public static <T> T convertToObject(@Nullable JsonElement pJson, String pMemberName, JsonDeserializationContext pContext, Class<? extends T> pAdapter) {
        if (pJson != null) {
            return (T)pContext.deserialize(pJson, pAdapter);
        }
        throw new JsonSyntaxException("Missing " + pMemberName);
    }

    public static <T> T getAsObject(JsonObject pJson, String pMemberName, JsonDeserializationContext pContext, Class<? extends T> pAdapter) {
        if (pJson.has(pMemberName)) {
            return GsonHelper.convertToObject(pJson.get(pMemberName), pMemberName, pContext, pAdapter);
        }
        throw new JsonSyntaxException("Missing " + pMemberName);
    }

    @Nullable
    public static <T> T getAsObject(JsonObject pJson, String pMemberName, @Nullable T pFallback, JsonDeserializationContext pContext, Class<? extends T> pAdapter) {
        return pJson.has(pMemberName) ? GsonHelper.convertToObject(pJson.get(pMemberName), pMemberName, pContext, pAdapter) : pFallback;
    }

    public static String getType(@Nullable JsonElement pJson) {
        String s = StringUtils.abbreviateMiddle((String)String.valueOf(pJson), (String)"...", (int)10);
        if (pJson == null) {
            return "null (missing)";
        }
        if (pJson.isJsonNull()) {
            return "null (json)";
        }
        if (pJson.isJsonArray()) {
            return "an array (" + s + ")";
        }
        if (pJson.isJsonObject()) {
            return "an object (" + s + ")";
        }
        if (pJson.isJsonPrimitive()) {
            JsonPrimitive jsonprimitive = pJson.getAsJsonPrimitive();
            if (jsonprimitive.isNumber()) {
                return "a number (" + s + ")";
            }
            if (jsonprimitive.isBoolean()) {
                return "a boolean (" + s + ")";
            }
        }
        return s;
    }

    @Nullable
    public static <T> T fromNullableJson(Gson pGson, Reader pReader, Class<T> pAdapter, boolean pLenient) {
        try {
            JsonReader jsonreader = new JsonReader(pReader);
            jsonreader.setLenient(pLenient);
            return (T)pGson.getAdapter(pAdapter).read(jsonreader);
        }
        catch (IOException ioexception) {
            throw new JsonParseException((Throwable)ioexception);
        }
    }

    public static <T> T fromJson(Gson pGson, Reader pReader, Class<T> pAdapter, boolean pLenient) {
        T t = GsonHelper.fromNullableJson(pGson, pReader, pAdapter, pLenient);
        if (t == null) {
            throw new JsonParseException("JSON data was null or empty");
        }
        return t;
    }

    @Nullable
    public static <T> T fromNullableJson(Gson pGson, Reader pReader, TypeToken<T> pType, boolean pLenient) {
        try {
            JsonReader jsonreader = new JsonReader(pReader);
            jsonreader.setLenient(pLenient);
            return (T)pGson.getAdapter(pType).read(jsonreader);
        }
        catch (IOException ioexception) {
            throw new JsonParseException((Throwable)ioexception);
        }
    }

    public static <T> T fromJson(Gson pGson, Reader pReader, TypeToken<T> pType, boolean pLenient) {
        T t = GsonHelper.fromNullableJson(pGson, pReader, pType, pLenient);
        if (t == null) {
            throw new JsonParseException("JSON data was null or empty");
        }
        return t;
    }

    @Nullable
    public static <T> T fromNullableJson(Gson pGson, String pJson, TypeToken<T> pType, boolean pLenient) {
        return GsonHelper.fromNullableJson(pGson, (Reader)new StringReader(pJson), pType, pLenient);
    }

    public static <T> T fromJson(Gson pGson, String pJson, Class<T> pAdapter, boolean pLenient) {
        return GsonHelper.fromJson(pGson, (Reader)new StringReader(pJson), pAdapter, pLenient);
    }

    @Nullable
    public static <T> T fromNullableJson(Gson pGson, String pJson, Class<T> pAdapter, boolean pLenient) {
        return GsonHelper.fromNullableJson(pGson, (Reader)new StringReader(pJson), pAdapter, pLenient);
    }

    public static <T> T fromJson(Gson pGson, Reader pReader, TypeToken<T> pType) {
        return GsonHelper.fromJson(pGson, pReader, pType, false);
    }

    @Nullable
    public static <T> T fromNullableJson(Gson pGson, String pJson, TypeToken<T> pType) {
        return GsonHelper.fromNullableJson(pGson, pJson, pType, false);
    }

    public static <T> T fromJson(Gson pGson, Reader pReader, Class<T> pJsonClass) {
        return GsonHelper.fromJson(pGson, pReader, pJsonClass, false);
    }

    public static <T> T fromJson(Gson pGson, String pJson, Class<T> pAdapter) {
        return GsonHelper.fromJson(pGson, pJson, pAdapter, false);
    }

    public static JsonObject parse(String pJson, boolean pLenient) {
        return GsonHelper.parse(new StringReader(pJson), pLenient);
    }

    public static JsonObject parse(Reader pReader, boolean pLenient) {
        return GsonHelper.fromJson(GSON, pReader, JsonObject.class, pLenient);
    }

    public static JsonObject parse(String pJson) {
        return GsonHelper.parse(pJson, false);
    }

    public static JsonObject parse(Reader pReader) {
        return GsonHelper.parse(pReader, false);
    }

    public static JsonArray parseArray(String pString) {
        return GsonHelper.parseArray(new StringReader(pString));
    }

    public static JsonArray parseArray(Reader pReader) {
        return GsonHelper.fromJson(GSON, pReader, JsonArray.class, false);
    }

    public static String toStableString(JsonElement pJson) {
        StringWriter stringwriter = new StringWriter();
        JsonWriter jsonwriter = new JsonWriter((Writer)stringwriter);
        try {
            GsonHelper.writeValue(jsonwriter, pJson, Comparator.naturalOrder());
        }
        catch (IOException ioexception) {
            throw new AssertionError((Object)ioexception);
        }
        return stringwriter.toString();
    }

    public static void writeValue(JsonWriter pWriter, @Nullable JsonElement pJsonElement, @Nullable Comparator<String> pSorter) throws IOException {
        if (pJsonElement != null && !pJsonElement.isJsonNull()) {
            if (pJsonElement.isJsonPrimitive()) {
                JsonPrimitive jsonprimitive = pJsonElement.getAsJsonPrimitive();
                if (jsonprimitive.isNumber()) {
                    pWriter.value(jsonprimitive.getAsNumber());
                } else if (jsonprimitive.isBoolean()) {
                    pWriter.value(jsonprimitive.getAsBoolean());
                } else {
                    pWriter.value(jsonprimitive.getAsString());
                }
            } else if (pJsonElement.isJsonArray()) {
                pWriter.beginArray();
                for (JsonElement jsonelement : pJsonElement.getAsJsonArray()) {
                    GsonHelper.writeValue(pWriter, jsonelement, pSorter);
                }
                pWriter.endArray();
            } else {
                if (!pJsonElement.isJsonObject()) {
                    throw new IllegalArgumentException("Couldn't write " + pJsonElement.getClass());
                }
                pWriter.beginObject();
                for (Map.Entry<String, JsonElement> entry : GsonHelper.sortByKeyIfNeeded(pJsonElement.getAsJsonObject().entrySet(), pSorter)) {
                    pWriter.name(entry.getKey());
                    GsonHelper.writeValue(pWriter, entry.getValue(), pSorter);
                }
                pWriter.endObject();
            }
        } else {
            pWriter.nullValue();
        }
    }

    private static Collection<Map.Entry<String, JsonElement>> sortByKeyIfNeeded(Collection<Map.Entry<String, JsonElement>> pEntries, @Nullable Comparator<String> pSorter) {
        if (pSorter == null) {
            return pEntries;
        }
        ArrayList<Map.Entry<String, JsonElement>> list = new ArrayList<Map.Entry<String, JsonElement>>(pEntries);
        list.sort(Map.Entry.comparingByKey(pSorter));
        return list;
    }
}

