/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.proxy;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.utils.IResourceProvider;
import org.zeith.hammeranims.core.proxy.CommonProxy;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;

public class ServerProxy
extends CommonProxy {
    @Override
    public void construct() {
        super.construct();
        MinecraftForge.EVENT_BUS.addListener(this::reloadResources);
    }

    public void reloadResources(AddReloadListenerEvent e) {
        e.addListener((preparationBarrier, resourceManager, profilerFiller, profilerFiller1, pBackgroundExecutor, pGameExecutor) -> this.reloadRegistries(preparationBarrier, ServerProxy.wrapClassLoaderResources(), false, pGameExecutor, pBackgroundExecutor));
    }

    public static IResourceProvider wrapClassLoaderResources() {
        Map<String, IModFile> namespace2ModFile = ModList.get().getModFiles().stream().flatMap(info -> info.getMods().stream().map(IModInfo::getNamespace).map(ns -> Tuples.immutable((Object)ns, (Object)info.getFile()))).collect(Collectors.toMap(Tuple2::a, Tuple2::b));
        IResourceProvider aux = IResourceProvider.or(HammerAnimationsApi.getAuxiliaryResourceProviders());
        return path -> {
            IModFile owner = (IModFile)namespace2ModFile.get(path.m_135827_());
            Path res = owner.findResource(new String[]{"assets", path.m_135827_(), path.m_135815_()});
            if (Files.isRegularFile(res, new LinkOption[0])) {
                try {
                    return Optional.of(Files.readAllBytes(res));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return aux.read(path);
        };
    }
}

