/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.proxy;

import com.google.common.base.Stopwatch;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Matrix3f;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.animation.data.effects.AnimatedParticleEffect;
import org.zeith.hammeranims.api.event.ReloadHammerAnimationsEvent;
import org.zeith.hammeranims.api.geometry.event.RefreshStaleModelsEvent;
import org.zeith.hammeranims.api.geometry.model.IGeometricModel;
import org.zeith.hammeranims.api.particles.emitter.IParticleRotationUpdater;
import org.zeith.hammeranims.api.utils.IExtendedResourceProvider;
import org.zeith.hammeranims.api.utils.IResourceProvider;
import org.zeith.hammeranims.core.impl.api.geometry.GeometryDataImpl;
import org.zeith.hammeranims.core.impl.api.particles.ExtraParticleEffects;
import org.zeith.hammerlib.util.java.IOUtils;

public class CommonProxy {
    public void construct() {
    }

    public IGeometricModel createGeometryData(GeometryDataImpl def) {
        return IGeometricModel.EMPTY;
    }

    public Level getClientWorld() {
        return null;
    }

    protected CompletableFuture<Void> reloadRegistries(PreparableReloadListener.PreparationBarrier pStage, IResourceProvider provider, boolean clientSide, Executor gameExecutor, Executor backgroundExecutor) {
        Stopwatch sw = Stopwatch.createStarted();
        HammerAnimations.LOG.info("Reloading {} registries...", (Object)"HammerAnimations");
        Stream.Builder tasks = Stream.builder();
        ReloadHammerAnimationsEvent.EnqueueReloads queues = new ReloadHammerAnimationsEvent.EnqueueReloads(provider, clientSide, tasks::add, gameExecutor, backgroundExecutor);
        Collection animations = HammerAnimationsApi.animations().getValues();
        HammerAnimations.LOG.info("Reloading {} animations.", (Object)animations.size());
        queues.enqueue(animations.stream().map(ctr -> () -> ctr.reload(provider)), CompletableFuture::runAsync);
        Collection geometries = HammerAnimationsApi.geometries().getValues();
        HammerAnimations.LOG.info("Reloading {} models.", (Object)geometries.size());
        queues.enqueue(geometries.stream().map(ctr -> () -> ctr.reload(provider)), CompletableFuture::runAsync);
        Collection particles = HammerAnimationsApi.particleContainers().getValues();
        HammerAnimations.LOG.info("Reloading {} particles.", (Object)particles.size());
        queues.enqueue(particles.stream().map(ctr -> () -> ctr.reload(provider)), CompletableFuture::runAsync);
        HammerAnimationsApi.EVENT_BUS.post((Event)queues);
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])tasks.build().toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)pStage).m_6769_(arg_0))).thenRunAsync(() -> {
            if (clientSide) {
                HammerAnimationsApi.EVENT_BUS.post((Event)new RefreshStaleModelsEvent());
            }
            HammerAnimationsApi.EVENT_BUS.post((Event)new ReloadHammerAnimationsEvent.Post(provider, clientSide));
            HammerAnimations.LOG.info("{} registries reloaded in {} ms", (Object)"HammerAnimations", (Object)sw.stop().elapsed(TimeUnit.MILLISECONDS));
        }, gameExecutor);
    }

    public static IExtendedResourceProvider wrapVanillaResources(final ResourceManager manager) {
        final IResourceProvider aux = IResourceProvider.or(HammerAnimationsApi.getAuxiliaryResourceProviders());
        return new IExtendedResourceProvider(){

            @Override
            public Optional<byte[]> read(ResourceLocation path) {
                Optional<byte[]> optional;
                block8: {
                    InputStream in = ((Resource)manager.m_213713_(path).orElseThrow(FileNotFoundException::new)).m_215507_();
                    try {
                        optional = Optional.of(IOUtils.pipeOut((InputStream)in));
                        if (in == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            return aux.read(path);
                        }
                    }
                    in.close();
                }
                return optional;
            }

            @Override
            public List<byte[]> readAll(ResourceLocation path) {
                ArrayList<byte[]> all = new ArrayList<byte[]>(manager.m_213829_(path).stream().map(r -> {
                    byte[] byArray;
                    block8: {
                        InputStream in = r.m_215507_();
                        try {
                            byArray = IOUtils.pipeOut((InputStream)in);
                            if (in == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException ignored) {
                                return null;
                            }
                        }
                        in.close();
                    }
                    return byArray;
                }).filter(Objects::nonNull).toList());
                for (IResourceProvider provider : HammerAnimationsApi.getAuxiliaryResourceProviders()) {
                    provider.read(path).ifPresent(all::add);
                }
                return all;
            }
        };
    }

    public IParticleRotationUpdater createParticle(AnimatedParticleEffect effect, Matrix3f rotation, Vec3 pos) {
        return null;
    }

    public ExtraParticleEffects getExtraParticles() {
        return null;
    }
}

