/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.joml.Matrix3f;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.animation.data.effects.AnimatedParticleEffect;
import org.zeith.hammeranims.api.geometry.model.IGeometricModel;
import org.zeith.hammeranims.api.particles.IParticleContainer;
import org.zeith.hammeranims.api.particles.emitter.IParticleRotationUpdater;
import org.zeith.hammeranims.api.utils.IExtendedResourceProvider;
import org.zeith.hammeranims.core.client.CommandReloadHA;
import org.zeith.hammeranims.core.client.model.GeometricModelImpl;
import org.zeith.hammeranims.core.client.particle.ParticleWithEmitter;
import org.zeith.hammeranims.core.impl.api.geometry.GeometryDataImpl;
import org.zeith.hammeranims.core.impl.api.particles.ExtraParticleEffects;
import org.zeith.hammeranims.core.proxy.CommonProxy;
import org.zeith.hammeranims.net.PacketProvideCustomParticleEffectList;

public class ClientProxy
extends CommonProxy {
    protected static final List<IGeometricModel> createdModels = new ArrayList<IGeometricModel>();
    protected static final List<IGeometricModel> disposeModels = new ArrayList<IGeometricModel>();
    protected static ExtraParticleEffects extraEffects;
    private boolean inWorld;

    @Override
    public IParticleRotationUpdater createParticle(AnimatedParticleEffect effect, Matrix3f rotation, Vec3 pos) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        IParticleContainer container = effect.getParticle();
        if (world == null || container == null) {
            return null;
        }
        ParticleWithEmitter pwe = new ParticleWithEmitter(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, container);
        if (rotation != null) {
            pwe.getEmitter().rotation = rotation;
            pwe.getEmitter().lastWorldTick = world.m_46467_();
        }
        pwe.spawn();
        return pwe.getEmitter();
    }

    @Override
    public ExtraParticleEffects getExtraParticles() {
        return extraEffects;
    }

    @Override
    public void construct() {
        super.construct();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(this::registerReloaders);
        forgeBus.addListener(this::clientTick);
        forgeBus.addListener(this::registerClientCommand);
    }

    private void clientTick(TickEvent.ClientTickEvent e) {
        boolean inWorldRN;
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        if (!disposeModels.isEmpty()) {
            HammerAnimations.LOG.info("Disposing {} OpenGL models.", (Object)disposeModels.size());
            while (!disposeModels.isEmpty()) {
                disposeModels.remove(0).dispose();
            }
            HammerAnimations.LOG.info("All previous models disposed.");
        }
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = inWorldRN = mc.f_91073_ != null && mc.m_91403_() != null;
        if (inWorldRN != this.inWorld) {
            this.inWorld = inWorldRN;
            if (inWorldRN) {
                PacketProvideCustomParticleEffectList.toServer();
            }
        }
    }

    public void registerClientCommand(RegisterClientCommandsEvent e) {
        e.getDispatcher().register(CommandReloadHA.command());
    }

    public void registerReloaders(RegisterClientReloadListenersEvent e) {
        e.registerReloadListener((preparationBarrier, resourceManager, profilerFiller, profilerFiller1, pBackgroundExecutor, pGameExecutor) -> ClientProxy.performReload(preparationBarrier));
    }

    @Override
    public IGeometricModel createGeometryData(GeometryDataImpl def) {
        GeometricModelImpl model = new GeometricModelImpl(def);
        createdModels.add(model);
        return model;
    }

    @Override
    public Level getClientWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static CompletableFuture<Void> performReload() {
        return ClientProxy.performReload(CompletableFuture::completedFuture);
    }

    public static CompletableFuture<Void> performReload(PreparableReloadListener.PreparationBarrier b) {
        disposeModels.addAll(createdModels);
        createdModels.clear();
        Minecraft mc = Minecraft.m_91087_();
        IExtendedResourceProvider res = ClientProxy.wrapVanillaResources(mc.m_91098_());
        return CompletableFuture.allOf(new CompletableFuture[]{ExtraParticleEffects.load(res, Util.m_183991_()).thenAccept(fx -> {
            extraEffects = fx;
        }), HammerAnimations.PROXY.reloadRegistries(b, res, true, (Executor)mc, Util.m_183991_())}).thenRun(() -> Minecraft.m_91087_().execute(() -> {
            ClientPacketListener net = Minecraft.m_91087_().m_91403_();
            if (net == null || Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            PacketProvideCustomParticleEffectList.toServer();
        }));
    }
}

