/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.js;

import java.util.HashMap;
import java.util.Random;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.minecraft.util.Mth;
import org.zeith.hammeranims.api.animation.interp.IVariableAccess;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.core.js.ExpressionFixer;
import org.zeith.hammeranims.core.js.IDoubleTest;
import org.zeith.hammeranims.core.js.JsFactory;
import org.zeith.hammerlib.util.java.tuples.Tuple2;

public class ExpressionParser {
    public static final MathJS MATH = new MathJS();
    private static final Random rng = new Random();

    public static <T extends IVariableAccess> InterpolatedDouble<T> parse(String expression) {
        expression = ExpressionFixer.fixExpression(expression);
        try {
            return InterpolatedDouble.constant(Double.parseDouble(expression));
        }
        catch (Throwable throwable) {
            HashMap<String, Object> js = new HashMap<String, Object>();
            try {
                js.put("Java", null);
                js.put("Math", MATH);
                js.put("math", MATH);
                String fun = "function get() {\n\treturn " + expression + ";\n}";
                Tuple2<ScriptEngine, IDoubleTest> res = JsFactory.parse(IDoubleTest.class, js, fun);
                if (res == null) {
                    return query -> 0.0;
                }
                IDoubleTest t = (IDoubleTest)res.b();
                return query -> {
                    try {
                        query.putObjects(((ScriptEngine)res.a())::put);
                        return t.get();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        return Double.NaN;
                    }
                };
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class MathJS {
        public final double pi = Math.PI;

        public double cos(double x) {
            return Mth.m_14089_((float)((float)(x * 0.01745329238474369)));
        }

        public double sin(double x) {
            return Mth.m_14031_((float)((float)(x * 0.01745329238474369)));
        }

        public double abs(double x) {
            return Math.abs(x);
        }

        public double clamp(double value, double min, double max) {
            return value < min ? min : (value > max ? max : value);
        }

        public double pow(double base, double exponent) {
            return Math.pow(base, exponent);
        }

        public double sqrt(double x) {
            return Math.sqrt(x);
        }

        public double asin(double x) {
            return Math.asin(x);
        }

        public double acos(double x) {
            return Math.acos(x);
        }

        public double atan(double x) {
            return Math.atan(x);
        }

        public double atan2(double y, double x) {
            return Math.atan2(y, x);
        }

        public double random(double low, double high) {
            return low + Math.random() * (high - low);
        }

        public int random_integer(int low, int high) {
            return low + rng.nextInt(high - low) + 1;
        }

        public double ceil(double x) {
            return Math.ceil(x);
        }

        public double floor(double x) {
            return Math.floor(x);
        }

        public double ln(double x) {
            return Math.log(x);
        }

        public double exp(double x) {
            return Math.exp(x);
        }

        public double hermite_blend(double t) {
            return 3.0 * Math.pow(t, 2.0) - 2.0 * MATH.pow(t, 3.0);
        }

        public double die_roll(int num, double low, double high) {
            double sum = 0.0;
            for (int i = 0; i < num; ++i) {
                sum += this.random(low, high);
            }
            return sum;
        }

        public int die_roll_integer(int num, int low, int high) {
            int sum = 0;
            for (int i = 0; i < num; ++i) {
                sum += this.random_integer(low, high);
            }
            return sum;
        }

        public double round(double x) {
            return Math.round(x);
        }

        public int trunc(double value) {
            return (int)value;
        }

        public double mod(double value, double denominator) {
            return value % denominator;
        }

        public double lerp(double a, double b, double O_to_1) {
            return a + (b - a) * O_to_1;
        }

        public double max(double a, double b) {
            return Math.max(a, b);
        }

        public double min(double a, double b) {
            return Math.min(a, b);
        }

        public double min_angle(double value) {
            return ((value + 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
        }

        public double lerprotate(double start, double end, double t) {
            start = (start % 360.0 + 360.0) % 360.0;
            end = (end % 360.0 + 360.0) % 360.0;
            double angleDifference = ((end - start + 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
            double interpolatedAngle = start + t * angleDifference;
            interpolatedAngle = (interpolatedAngle % 360.0 + 360.0) % 360.0;
            return interpolatedAngle;
        }
    }
}

