/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.jomljson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import org.joml.Vector3f;

public class Vector3fGsonAdapter
implements JsonSerializer<Vector3f>,
JsonDeserializer<Vector3f> {
    public Vector3f deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonArray array = json.getAsJsonArray();
        if (array.size() != 3) {
            throw new JsonSyntaxException("Expected 3 elements in Vector3f array, found: " + array.size());
        }
        return new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
    }

    public JsonElement serialize(Vector3f src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(src.x));
        array.add((Number)Float.valueOf(src.y));
        array.add((Number)Float.valueOf(src.z));
        return array;
    }
}

