/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.jomljson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import org.joml.Vector3d;

public class Vector3dGsonAdapter
implements JsonSerializer<Vector3d>,
JsonDeserializer<Vector3d> {
    public static final char INFINITY = '\u221e';
    public static final String POS_INF = "+\u221e";
    public static final String NEG_INF = "-\u221e";

    public Vector3d deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonArray array = json.getAsJsonArray();
        if (array.size() != 3) {
            throw new JsonSyntaxException("Expected 3 elements in Vector3d array, found: " + array.size());
        }
        JsonElement xE = array.get(0);
        JsonElement yE = array.get(1);
        JsonElement zE = array.get(2);
        double x = xE.getAsString().equals(POS_INF) ? Double.POSITIVE_INFINITY : (xE.getAsString().equals(NEG_INF) ? Double.NEGATIVE_INFINITY : xE.getAsDouble());
        double y = yE.getAsString().equals(POS_INF) ? Double.POSITIVE_INFINITY : (yE.getAsString().equals(NEG_INF) ? Double.NEGATIVE_INFINITY : yE.getAsDouble());
        double z = zE.getAsString().equals(POS_INF) ? Double.POSITIVE_INFINITY : (zE.getAsString().equals(NEG_INF) ? Double.NEGATIVE_INFINITY : zE.getAsDouble());
        return new Vector3d(x, y, z);
    }

    public JsonElement serialize(Vector3d src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray array = new JsonArray();
        if (src.x == Double.NEGATIVE_INFINITY) {
            array.add(NEG_INF);
        } else if (src.x == Double.POSITIVE_INFINITY) {
            array.add(POS_INF);
        } else {
            array.add((Number)src.x);
        }
        if (src.y == Double.NEGATIVE_INFINITY) {
            array.add(NEG_INF);
        } else if (src.y == Double.POSITIVE_INFINITY) {
            array.add(POS_INF);
        } else {
            array.add((Number)src.y);
        }
        if (src.z == Double.NEGATIVE_INFINITY) {
            array.add(NEG_INF);
        } else if (src.z == Double.POSITIVE_INFINITY) {
            array.add(POS_INF);
        } else {
            array.add((Number)src.z);
        }
        return array;
    }
}

