/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.particles;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.particles.IParticleContainer;
import org.zeith.hammeranims.api.particles.ParticleEffect;
import org.zeith.hammeranims.api.particles.event.DecodeParticleEffectEvent;
import org.zeith.hammeranims.api.utils.IResourceProvider;

public class ParticleContainerImpl
implements IParticleContainer {
    public final String suffix;
    protected ParticleEffect effect = ParticleEffect.empty(this);

    public ParticleContainerImpl(String suffix) {
        this.suffix = suffix;
    }

    public ParticleContainerImpl() {
        this.suffix = ".particle.json";
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public ParticleEffect getParticleEffect() {
        return this.effect;
    }

    public static Optional<ParticleEffect> defaultReadParticle(ResourceLocation path, IResourceProvider resources, IParticleContainer container, Optional<String> text) {
        return text.map(txt -> {
            ResourceLocation key = container.getRegistryKey();
            try {
                DecodeParticleEffectEvent evt = new DecodeParticleEffectEvent(path, resources, container, (String)txt);
                HammerAnimationsApi.EVENT_BUS.post((Event)evt);
                return evt.getDecoded();
            }
            catch (Exception e) {
                HammerAnimations.LOG.error("Failed to load geometry " + key + ", skipping.", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public void reload(IResourceProvider resources) {
        ResourceLocation key = this.getRegistryKey();
        ResourceLocation path = new ResourceLocation(key.m_135827_(), "bedrock/particles/" + key.m_135815_() + this.suffix);
        this.effect = Optional.ofNullable(ParticleContainerImpl.defaultReadParticle(path, resources, this, resources.readAsString(path)).orElseGet(() -> {
            HammerAnimations.LOG.warn("Unable to load particle effect {} from file {}", (Object)key, (Object)path);
            return null;
        })).orElseGet(() -> ParticleEffect.empty(this));
        if (HammerAnimationsApi.LOG_RELOADS) {
            HammerAnimations.LOG.debug("Loaded {} particles container with blend type {}.", (Object)key, (Object)this.effect.material.id);
        }
    }
}

