/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.particles;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.particles.IParticleContainer;
import org.zeith.hammeranims.api.particles.ParticleEffect;
import org.zeith.hammeranims.api.utils.IExtendedResourceProvider;
import org.zeith.hammeranims.api.utils.IResourceProvider;
import org.zeith.hammeranims.core.impl.api.particles.ParticleContainerImpl;
import org.zeith.hammeranims.core.utils.InstanceHelpers;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.shaded.json.JSONArray;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class ExtraParticleEffects {
    private final Function<ResourceLocation, IParticleContainer> loader;
    private final Map<ResourceLocation, IParticleContainer> extraEffects;

    public ExtraParticleEffects(Function<ResourceLocation, IParticleContainer> loader, Map<ResourceLocation, IParticleContainer> extraEffects) {
        this.loader = loader;
        this.extraEffects = Collections.synchronizedMap(new HashMap<ResourceLocation, IParticleContainer>(extraEffects));
    }

    public Set<ResourceLocation> getKeys() {
        return this.extraEffects.keySet();
    }

    public IParticleContainer resolve(ResourceLocation id) {
        return this.extraEffects.computeIfAbsent(id, this.loader);
    }

    public static CompletableFuture<ExtraParticleEffects> load(IExtendedResourceProvider resources, Executor exe) {
        HashSet<ResourceLocation> toLoad = new HashSet<ResourceLocation>();
        for (String extras : resources.readAllAsString(new ResourceLocation("hammeranims", "bedrock/custom_particles.json"))) {
            JSONObject res = (JSONObject)Cast.cast((Object)new JSONTokener(extras).nextValue(), JSONObject.class);
            if (res == null) {
                HammerAnimations.LOG.warn("Found invalid custom_particles.json");
                continue;
            }
            JSONArray load = res.optJSONArray("load");
            if (load == null) continue;
            for (int i = 0; i < load.length(); ++i) {
                toLoad.add(InstanceHelpers.tryParseLocation(load.getString(i)));
            }
        }
        HammerAnimations.LOG.info("Loading {} custom particle effects.", (Object)toLoad.size());
        List<CompletableFuture> containers = toLoad.stream().map(id -> CompletableFuture.supplyAsync(() -> ExtraParticleEffects.createUnregistered(resources, id), exe)).collect(Collectors.toList());
        return CompletableFuture.allOf(containers.toArray(new CompletableFuture[0])).thenApply(__ -> {
            ImmutableMap.Builder extras = ImmutableMap.builder();
            for (CompletableFuture c : containers) {
                UnregisteredParticleContainer upc = (UnregisteredParticleContainer)c.join();
                extras.put((Object)upc.getRegistryKey(), (Object)upc);
            }
            return new ExtraParticleEffects(id -> ExtraParticleEffects.createUnregistered(resources, id), (Map<ResourceLocation, IParticleContainer>)extras.build());
        });
    }

    public static UnregisteredParticleContainer createUnregistered(IExtendedResourceProvider resources, ResourceLocation id) {
        UnregisteredParticleContainer ctr = new UnregisteredParticleContainer(id);
        ResourceLocation path = new ResourceLocation(id.m_135827_(), "bedrock/particles/" + id.m_135815_() + ".particle.json");
        ctr.effect = Optional.ofNullable(ParticleContainerImpl.defaultReadParticle(path, resources, ctr, resources.readAsString(path)).orElseGet(() -> {
            HammerAnimations.LOG.warn("Unable to load custom particle effect {} from file {}", (Object)id, (Object)path);
            return null;
        })).orElseGet(() -> ParticleEffect.empty(ctr));
        if (HammerAnimationsApi.LOG_RELOADS) {
            HammerAnimations.LOG.debug("Loaded custom particle effect {}", (Object)id);
        }
        return ctr;
    }

    public static class UnregisteredParticleContainer
    implements IParticleContainer {
        protected final ResourceLocation id;
        protected ParticleEffect effect;

        public UnregisteredParticleContainer(ResourceLocation id) {
            this.id = id;
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        public ParticleEffect getParticleEffect() {
            return this.effect;
        }

        @Override
        public ResourceLocation getRegistryKey() {
            return this.id;
        }

        @Override
        public void reload(IResourceProvider provider) {
        }
    }
}

