/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.geometry.decoder;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumMap;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.zeith.hammeranims.core.client.model.CubeUVs;
import org.zeith.hammeranims.core.utils.EnumFacing;

public interface UVDefinition {
    public CubeUVs bake(Vector3f var1);

    public static class FaceUVDefinition {
        private final Vector2i uv;
        private final Vector2i size;

        public FaceUVDefinition(Vector2i uv, Vector2i size) {
            this.uv = uv;
            this.size = size;
        }

        public Vector2i uv() {
            return this.uv;
        }

        public Vector2i size() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FaceUVDefinition)) {
                return false;
            }
            FaceUVDefinition that = (FaceUVDefinition)o;
            if (!this.uv.equals((Object)that.uv)) {
                return false;
            }
            return this.size.equals((Object)that.size);
        }

        public int hashCode() {
            int result = this.uv.hashCode();
            result = 31 * result + this.size.hashCode();
            return result;
        }

        public static class Deserializer
        implements JsonDeserializer<FaceUVDefinition> {
            public FaceUVDefinition deserialize(JsonElement jsonIn, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject json = jsonIn.getAsJsonObject();
                Vector2i uv = (Vector2i)context.deserialize(json.get("uv"), Vector2i.class);
                Vector2i size = (Vector2i)context.deserialize(json.get("uv_size"), Vector2i.class);
                return new FaceUVDefinition(uv, size);
            }
        }
    }

    public static final class PerFace
    implements UVDefinition {
        private final EnumMap<EnumFacing, FaceUVDefinition> mappings;

        private PerFace(EnumMap<EnumFacing, FaceUVDefinition> mappings) {
            this.mappings = mappings;
        }

        @Override
        public CubeUVs bake(Vector3f size) {
            return new CubeUVs.FacedUVResolver(Collections.unmodifiableMap(this.mappings));
        }

        private static class Deserializer
        implements JsonDeserializer<PerFace> {
            public static final EnumFacing[] DIRECTIONS = EnumFacing.values();

            private Deserializer() {
            }

            public PerFace deserialize(JsonElement jsonIn, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject json = jsonIn.getAsJsonObject();
                EnumMap<EnumFacing, FaceUVDefinition> map = new EnumMap<EnumFacing, FaceUVDefinition>(EnumFacing.class);
                for (EnumFacing direction : DIRECTIONS) {
                    FaceUVDefinition face;
                    if (!json.has(direction.m_7912_()) || (face = (FaceUVDefinition)context.deserialize(json.get(direction.m_7912_()), FaceUVDefinition.class)) == null) continue;
                    map.put(direction, face);
                }
                return new PerFace(map);
            }
        }
    }

    public static final class Simple
    implements UVDefinition {
        private final Vector2i uv;

        private Simple(Vector2i uv) {
            this.uv = uv;
        }

        @Override
        public CubeUVs bake(Vector3f size) {
            return new CubeUVs.BoxUVResolver(this.uv, size);
        }

        private static class Deserializer
        implements JsonDeserializer<Simple> {
            private Deserializer() {
            }

            public Simple deserialize(JsonElement jsonIn, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new Simple((Vector2i)context.deserialize(jsonIn, Vector2i.class));
            }
        }
    }

    public static class Deserializer
    implements JsonDeserializer<UVDefinition> {
        private static final Simple.Deserializer simpleDecoder = new Simple.Deserializer();
        private static final PerFace.Deserializer perFaceDecoder = new PerFace.Deserializer();

        public UVDefinition deserialize(JsonElement jsonIn, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (jsonIn.isJsonArray()) {
                return simpleDecoder.deserialize(jsonIn, typeOfT, context);
            }
            return perFaceDecoder.deserialize(jsonIn, typeOfT, context);
        }
    }
}

