/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.geometry.decoder;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.zeith.hammeranims.core.client.model.ModelBoneF;
import org.zeith.hammeranims.core.client.model.ModelCubeF;
import org.zeith.hammeranims.core.impl.api.geometry.GeometryLocator;
import org.zeith.hammeranims.core.impl.api.geometry.PositionalModelImpl;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelCubeInfo;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelLocatorInfo;

public class ModelPartInfo {
    private final List<ModelCubeInfo> cubes;
    private final List<ModelLocatorInfo> locators;
    private final List<ModelPartInfo> children = new ArrayList<ModelPartInfo>();
    private final Vector3f pivot;
    private final Vector3f rotationDegrees;
    private final boolean neverRender;
    private final String name;
    private final String parentName;

    public ModelPartInfo(List<ModelCubeInfo> cubes, List<ModelLocatorInfo> locators, Vector3f pivot, Vector3f rotationDegrees, boolean neverRender, String name, String parentName) {
        this.cubes = cubes;
        this.locators = locators;
        this.pivot = pivot;
        this.rotationDegrees = rotationDegrees;
        this.neverRender = neverRender;
        this.name = name;
        this.parentName = parentName;
    }

    public static ModelPartInfo makeRoot() {
        return new ModelPartInfo((List<ModelCubeInfo>)ImmutableList.of(), (List<ModelLocatorInfo>)ImmutableList.of(), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), false, "root", null);
    }

    public void addChild(ModelPartInfo child) {
        this.children.add(child);
    }

    public void addChildren(List<ModelPartInfo> children) {
        this.children.addAll(children);
    }

    public PositionalModelImpl.PositionalBone bakePositional(@Nullable ModelPartInfo parent) {
        Vector3f rotationRads = new Vector3f((float)Math.PI / 180 * this.rotationDegrees.x(), (float)Math.PI / 180 * this.rotationDegrees.y(), (float)Math.PI / 180 * this.rotationDegrees.z());
        rotationRads.mul(-1.0f, -1.0f, 1.0f);
        Object2ObjectArrayMap bakedChildren = new Object2ObjectArrayMap();
        for (ModelPartInfo modelPartInfo : this.children) {
            bakedChildren.put((Object)modelPartInfo.name, (Object)modelPartInfo.bakePositional(this));
        }
        HashMap<String, GeometryLocator> bakedLocators = new HashMap<String, GeometryLocator>();
        for (ModelLocatorInfo locator : this.locators) {
            Vector3f off = locator.getOrigin();
            Vector3f rot = locator.getRotation();
            GeometryLocator.GeometryLocatorBuilder b = GeometryLocator.builder().name(locator.getName());
            if (parent != null) {
                b.offset(new Vector3f(-(off.x() - parent.pivot.x()), off.y() - parent.pivot.y(), off.z() - parent.pivot.z()));
            } else {
                b.offset(new Vector3f(-off.x(), off.y(), off.z()));
            }
            b.rotation(new Vector3f((float)Math.PI / 180 * rot.x(), (float)Math.PI / 180 * rot.y(), (float)Math.PI / 180 * rot.z()).mul(-1.0f, -1.0f, 1.0f));
            bakedLocators.put(locator.getName(), b.build());
        }
        PositionalModelImpl.PositionalBone positionalBone = new PositionalModelImpl.PositionalBone(this.name, rotationRads, (Map<String, PositionalModelImpl.PositionalBone>)bakedChildren, bakedLocators);
        if (parent != null) {
            positionalBone.setPos(-(this.pivot.x() - parent.pivot.x()), this.pivot.y() - parent.pivot.y(), this.pivot.z() - parent.pivot.z());
        } else {
            positionalBone.setPos(-this.pivot.x(), this.pivot.y(), this.pivot.z());
        }
        return positionalBone;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelBoneF bake(@Nullable ModelPartInfo parent, int textureWidth, int textureHeight) {
        ImmutableList.Builder bakedCubes = ImmutableList.builder();
        for (ModelCubeInfo cube : this.cubes) {
            bakedCubes.add((Object)cube.bake(this, textureWidth, textureHeight));
        }
        Vector3f rotationRads = new Vector3f((float)Math.PI / 180 * this.rotationDegrees.x(), (float)Math.PI / 180 * this.rotationDegrees.y(), (float)Math.PI / 180 * this.rotationDegrees.z());
        rotationRads.mul(-1.0f, -1.0f, 1.0f);
        Object2ObjectArrayMap bakedChildren = new Object2ObjectArrayMap();
        for (ModelPartInfo modelPartInfo : this.children) {
            bakedChildren.put(modelPartInfo.name, modelPartInfo.bake(this, textureWidth, textureHeight));
        }
        HashMap<String, GeometryLocator> bakedLocators = new HashMap<String, GeometryLocator>();
        for (ModelLocatorInfo locator : this.locators) {
            Vector3f off = locator.getOrigin();
            Vector3f rot = locator.getRotation();
            GeometryLocator.GeometryLocatorBuilder b = GeometryLocator.builder().name(locator.getName());
            if (parent != null) {
                b.offset(new Vector3f(-(off.x() - parent.pivot.x()), off.y() - parent.pivot.y(), off.z() - parent.pivot.z()));
            } else {
                b.offset(new Vector3f(-off.x(), off.y(), off.z()));
            }
            b.rotation(new Vector3f((float)Math.PI / 180 * rot.x(), (float)Math.PI / 180 * rot.y(), (float)Math.PI / 180 * rot.z()).mul(-1.0f, -1.0f, 1.0f));
            bakedLocators.put(locator.getName(), b.build());
        }
        ModelBoneF modelBoneF = new ModelBoneF(this.name, rotationRads, (List<ModelCubeF>)bakedCubes.build(), (Map<String, ModelBoneF>)bakedChildren, bakedLocators, this.neverRender);
        if (parent != null) {
            modelBoneF.m_104227_(-(this.pivot.x() - parent.pivot.x()), this.pivot.y() - parent.pivot.y(), this.pivot.z() - parent.pivot.z());
        } else {
            modelBoneF.m_104227_(-this.pivot.x(), this.pivot.y(), this.pivot.z());
        }
        return modelBoneF;
    }

    public List<ModelLocatorInfo> getLocators() {
        return this.locators;
    }

    public List<ModelPartInfo> getChildren() {
        return this.children;
    }

    public Vector3f getPivot() {
        return this.pivot;
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }
}

