/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.geometry.decoder;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.zeith.hammeranims.core.client.model.ModelCubeF;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelPartInfo;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.UVDefinition;

public class ModelCubeInfo {
    private final Vector3f origin;
    private final Vector3f size;
    private final UVDefinition uv;
    private final float inflate;
    private final boolean mirrored;

    public ModelCubeInfo(Vector3f origin, Vector3f size, UVDefinition uv, float inflate, boolean mirrored) {
        this.origin = origin;
        this.size = size;
        this.uv = uv;
        this.inflate = inflate;
        this.mirrored = mirrored;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelCubeF bake(ModelPartInfo ownerPart, int textureWidth, int textureHeight) {
        Vector3f origin = new Vector3f(-(this.origin.x() + this.size.x() - ownerPart.getPivot().x()), this.origin.y() - ownerPart.getPivot().y(), this.origin.z() - ownerPart.getPivot().z());
        float inflate = this.inflate;
        if (this.size.x() == 0.0f || this.size.y() == 0.0f || this.size.z() == 0.0f) {
            inflate = Math.max(0.008f, inflate);
        }
        return ModelCubeF.make(origin, this.size, this.uv.bake(this.size), inflate, this.mirrored, textureWidth, textureHeight);
    }
}

