/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.geometry.decoder;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.geometry.IGeometryContainer;
import org.zeith.hammeranims.api.utils.EmbeddedLocation;
import org.zeith.hammeranims.core.impl.api.geometry.GeometryDataImpl;
import org.zeith.hammeranims.core.impl.api.geometry.constrains.BoneConstraintsImpl;
import org.zeith.hammeranims.core.impl.api.geometry.constrains.GeometryConstrainsImpl;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelCubeInfo;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelLocatorInfo;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelMaterialInfo;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelMeshInfo;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelPartInfo;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.UVDefinition;
import org.zeith.hammeranims.core.jomljson.BoneConstrainsImplAdapter;
import org.zeith.hammeranims.core.jomljson.GeometryConstrainsImplAdapter;
import org.zeith.hammeranims.core.jomljson.Vector2iGsonAdapter;
import org.zeith.hammeranims.core.jomljson.Vector3dGsonAdapter;
import org.zeith.hammeranims.core.jomljson.Vector3fGsonAdapter;
import org.zeith.hammeranims.core.utils.GsonHelper;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;

public class GsonGeometryDecoder {
    private static final String[] ACCEPTABLE_FORMAT_VERSIONS = new String[]{"1.12.0"};
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Vector2i.class, (Object)new Vector2iGsonAdapter()).registerTypeAdapter(UVDefinition.FaceUVDefinition.class, (Object)new UVDefinition.FaceUVDefinition.Deserializer()).registerTypeAdapter(UVDefinition.class, (Object)new UVDefinition.Deserializer()).registerTypeAdapter(Vector3f.class, (Object)new Vector3fGsonAdapter()).registerTypeAdapter(Vector3d.class, (Object)new Vector3dGsonAdapter()).registerTypeAdapter(BoneConstraintsImpl.class, (Object)new BoneConstrainsImplAdapter()).registerTypeAdapter(GeometryConstrainsImpl.class, (Object)new GeometryConstrainsImplAdapter()).create();

    public static GeometryConstrainsImpl readGeometryConstraints(String text) {
        JsonObject json = GsonHelper.parse(text, true);
        return (GeometryConstrainsImpl)GSON.fromJson((JsonElement)json, GeometryConstrainsImpl.class);
    }

    public static List<Tuple2<EmbeddedLocation, GeometryDataImpl>> readGeometryFile(IGeometryContainer container, ResourceLocation location, String text) {
        if (text != null && !text.isEmpty()) {
            try {
                JsonObject json = GsonHelper.parse(text, true);
                return GsonGeometryDecoder.readGeometryFile(container, location, json);
            }
            catch (Throwable e) {
                throw new RuntimeException("Geometry file can't be read.", e);
            }
        }
        throw new RuntimeException("Geometry file not found: " + location);
    }

    private static List<Tuple2<EmbeddedLocation, GeometryDataImpl>> readGeometryFile(IGeometryContainer container, ResourceLocation fileLocation, JsonObject object) {
        ArrayList<Tuple2<EmbeddedLocation, GeometryDataImpl>> definitions = new ArrayList<Tuple2<EmbeddedLocation, GeometryDataImpl>>();
        for (Map.Entry entry : object.entrySet()) {
            if (((String)entry.getKey()).equals("format_version")) {
                String formatVersion = GsonHelper.convertToString((JsonElement)entry.getValue(), (String)entry.getKey());
                GsonGeometryDecoder.checkFormatVersion(fileLocation, formatVersion);
                continue;
            }
            if (!((String)entry.getKey()).equals("minecraft:geometry")) continue;
            Tuple2<EmbeddedLocation, GeometryDataImpl> identifierAndModel = GsonGeometryDecoder.parseGeometry(container, fileLocation, GsonHelper.convertToJsonArray((JsonElement)entry.getValue(), (String)entry.getKey()));
            definitions.add(identifierAndModel);
        }
        return definitions;
    }

    private static Tuple2<EmbeddedLocation, GeometryDataImpl> parseGeometry(IGeometryContainer container, ResourceLocation fileLocation, JsonArray subModelArr) {
        JsonObject subModel = GsonHelper.convertToJsonObject(subModelArr.get(0), "member of 'minecraft:geometry'");
        JsonArray bones = GsonHelper.getAsJsonArray(subModel, "bones");
        JsonObject description = GsonHelper.getAsJsonObject(subModel, "description");
        String identifier = GsonHelper.getAsString(description, "identifier");
        ModelMaterialInfo material = new ModelMaterialInfo(GsonHelper.getAsInt(description, "texture_width"), GsonHelper.getAsInt(description, "texture_height"));
        HashMap<String, ModelPartInfo> parts = new HashMap<String, ModelPartInfo>();
        for (JsonElement bone : bones) {
            ModelPartInfo part = GsonGeometryDecoder.parseBone(GsonHelper.convertToJsonObject(bone, "member of 'bones'"));
            parts.put(part.getName(), part);
        }
        ArrayList<ModelPartInfo> rootChildren = new ArrayList<ModelPartInfo>();
        for (ModelPartInfo value : parts.values()) {
            if (!value.getParentName().equals("root")) {
                ModelPartInfo parent = (ModelPartInfo)parts.get(value.getParentName());
                if (parent != null) {
                    parent.addChild(value);
                    continue;
                }
                throw new JsonSyntaxException("Can't find parent '" + value.getParentName() + "' for bone '" + value.getName() + "'");
            }
            rootChildren.add(value);
        }
        return Tuples.immutable((Object)new EmbeddedLocation(fileLocation, identifier), (Object)GsonGeometryDecoder.makeDefinition(container, material, rootChildren));
    }

    private static GeometryDataImpl makeDefinition(IGeometryContainer container, ModelMaterialInfo material, List<ModelPartInfo> roots) {
        ModelMeshInfo mesh = new ModelMeshInfo();
        ModelPartInfo root = mesh.getRoot();
        root.addChildren(roots);
        return GeometryDataImpl.create(container, mesh, material.getTextureWidth(), material.getTextureHeight());
    }

    private static ModelPartInfo parseBone(JsonObject bone) {
        Vector3f pivot = GsonHelper.getAsVec3f(bone, "pivot");
        Vector3f rotation = GsonHelper.getAsVec3f(bone, "rotation", new Vector3f(0.0f, 0.0f, 0.0f));
        boolean mirror = GsonHelper.getAsBoolean(bone, "mirror", false);
        boolean neverRender = GsonHelper.getAsBoolean(bone, "neverRender", false);
        String name = GsonHelper.getAsString(bone, "name");
        String parentName = GsonHelper.getAsString(bone, "parent", "root");
        ArrayList<ModelPartInfo> children = new ArrayList<ModelPartInfo>();
        ArrayList<ModelCubeInfo> cubes = new ArrayList<ModelCubeInfo>();
        if (bone.has("cubes")) {
            int i = 0;
            for (JsonElement cubeJson : GsonHelper.getAsJsonArray(bone, "cubes")) {
                JsonObject cubeObject = GsonHelper.convertToJsonObject(cubeJson, "member of 'cubes'");
                Vector3f origin = GsonHelper.getAsVec3f(cubeObject, "origin");
                Vector3f size = GsonHelper.getAsVec3f(cubeObject, "size");
                UVDefinition uv = (UVDefinition)GSON.fromJson(cubeObject.get("uv"), UVDefinition.class);
                boolean cubeMirror = GsonHelper.getAsBoolean(cubeObject, "mirror", mirror);
                float inflate = GsonHelper.getAsFloat(cubeObject, "inflate", 0.0f);
                ModelCubeInfo cube = new ModelCubeInfo(origin, size, uv, inflate, cubeMirror);
                if (cubeObject.has("rotation")) {
                    Vector3f innerRotation = GsonHelper.getAsVec3f(cubeObject, "rotation", new Vector3f(0.0f, 0.0f, 0.0f));
                    Vector3f innerPivot = GsonHelper.getAsVec3f(cubeObject, "pivot", new Vector3f(0.0f, 0.0f, 0.0f));
                    children.add(new ModelPartInfo(Collections.singletonList(cube), (List<ModelLocatorInfo>)ImmutableList.of(), innerPivot, innerRotation, false, name + "_generated_" + i++, name));
                    continue;
                }
                cubes.add(cube);
            }
        }
        ArrayList<ModelLocatorInfo> locators = new ArrayList<ModelLocatorInfo>();
        if (bone.has("locators")) {
            boolean i = false;
            JsonObject locs = GsonHelper.getAsJsonObject(bone, "locators");
            for (Map.Entry locEntry : locs.entrySet()) {
                JsonElement theLoc = (JsonElement)locEntry.getValue();
                if (theLoc.isJsonObject()) {
                    JsonObject obj = theLoc.getAsJsonObject();
                    Vector3f offset = GsonHelper.getAsVec3f(obj, "offset");
                    Vector3f innerRotation = GsonHelper.getAsVec3f(obj, "rotation", new Vector3f(0.0f, 0.0f, 0.0f));
                    locators.add(new ModelLocatorInfo(offset, innerRotation, (String)locEntry.getKey()));
                    continue;
                }
                Vector3f origin = GsonHelper.toVec3f(GsonHelper.convertToJsonArray((JsonElement)locEntry.getValue(), (String)locEntry.getKey()), (String)locEntry.getKey());
                locators.add(new ModelLocatorInfo(origin, new Vector3f(), (String)locEntry.getKey()));
            }
        }
        ModelPartInfo part = new ModelPartInfo(cubes, locators, pivot, rotation, neverRender, name, parentName);
        part.addChildren(children);
        return part;
    }

    private static void checkFormatVersion(ResourceLocation fileLocation, String version) {
        if (!GsonGeometryDecoder.contains(ACCEPTABLE_FORMAT_VERSIONS, version)) {
            HammerAnimations.LOG.warn("[{}]: Potentially unsupported version of geometry {}. Supported versions: {}", (Object)fileLocation, (Object)version, (Object)Arrays.toString(ACCEPTABLE_FORMAT_VERSIONS));
        }
    }

    public static <T> boolean contains(T[] array, T object) {
        for (T t : array) {
            if (!t.equals(object)) continue;
            return true;
        }
        return false;
    }
}

