/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.zeith.hammeranims.api.geometry.IGeometryContainer;
import org.zeith.hammeranims.api.geometry.constrains.IBoneConstraints;
import org.zeith.hammeranims.api.geometry.constrains.IGeometryConstraints;
import org.zeith.hammeranims.api.geometry.model.GeometryPose;
import org.zeith.hammeranims.api.geometry.model.GeometryTransforms;
import org.zeith.hammeranims.api.geometry.model.IBone;
import org.zeith.hammeranims.api.geometry.model.IPositionalModel;
import org.zeith.hammeranims.core.impl.api.geometry.GeometryLocator;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelMeshInfo;

public class PositionalModelImpl
implements IPositionalModel {
    protected final Map<String, List<PositionalBone>> parentTree = new HashMap<String, List<PositionalBone>>();
    protected final IGeometryContainer container;
    protected final IGeometryConstraints constraints;
    protected final PositionalBone root;
    protected final Map<String, PositionalBone> bones = new HashMap<String, PositionalBone>();
    protected final Map<String, IBoneConstraints> boneConstraints = new HashMap<String, IBoneConstraints>();
    protected final Map<String, PositionalBone> locatorSources = new HashMap<String, PositionalBone>();
    GeometryPose emptyPose = new GeometryPose(this::hasBone);

    private PositionalModelImpl(IGeometryContainer container, ModelMeshInfo mesh) {
        this.container = container;
        this.constraints = container.getConstraints();
        this.root = mesh.getRoot().bakePositional(null);
        this.registerBone(new Stack<PositionalBone>(), this.root);
    }

    protected void registerBone(Stack<PositionalBone> boneStack, PositionalBone part) {
        boneStack.push(part);
        this.bones.put(part.boxName, part);
        this.boneConstraints.put(part.boxName, this.constraints.getConstraints(part.boxName));
        this.parentTree.put(part.boxName, new ArrayList<PositionalBone>(boneStack));
        for (PositionalBone positionalBone : part.getChildren().values()) {
            this.registerBone(boneStack, positionalBone);
        }
        for (Map.Entry entry : part.getLocators().entrySet()) {
            this.locatorSources.put((String)entry.getKey(), part);
        }
        boneStack.pop();
    }

    public static PositionalModelImpl create(IGeometryContainer container, ModelMeshInfo mesh) {
        return new PositionalModelImpl(container, mesh);
    }

    @Override
    public IBone getRoot() {
        return this.root;
    }

    @Override
    public Set<String> getBoneNames() {
        return this.bones.keySet();
    }

    @Override
    public Collection<? extends IBone> getBones() {
        return this.bones.values();
    }

    @Override
    @Nullable
    public IBone getBone(String bone) {
        return this.bones.get(bone);
    }

    @Override
    public boolean hasBone(String bone) {
        return this.bones.containsKey(bone);
    }

    @Override
    public void resetPose() {
        for (PositionalBone s : this.bones.values()) {
            s.reset();
        }
    }

    @Override
    public GeometryPose emptyPose() {
        this.emptyPose.reset();
        return this.emptyPose;
    }

    @Override
    public void applyPose(GeometryPose pose) {
        Map<String, GeometryTransforms> poseBones = pose.getBoneTransforms();
        for (String boneKey : this.bones.keySet()) {
            PositionalBone bone = this.bones.get(boneKey);
            if (bone == null) continue;
            bone.reset();
            GeometryTransforms add = poseBones.get(boneKey);
            if (add == null) continue;
            add.applyConstraints(this.boneConstraints.get(boneKey));
            Vec3 translate = add.translation;
            Vec3 rotate = add.rotation.m_82490_(0.01745329238474369);
            Vec3 scale = add.scale;
            bone.offset.add((float)translate.f_82479_, (float)(-translate.f_82480_), (float)translate.f_82481_);
            bone.getRotation().sub((float)rotate.f_82479_, (float)rotate.f_82480_, (float)(-rotate.f_82481_));
            bone.getScale().mul((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
        }
    }

    @Override
    public boolean applyBoneTransforms(@Nonnull Matrix4f base, String bone) {
        List<PositionalBone> tree = this.parentTree.get(bone);
        if (tree == null || tree.isEmpty()) {
            return false;
        }
        for (PositionalBone f : tree) {
            f.applyTransforms(base);
        }
        return true;
    }

    @Override
    public boolean applyBoneTransforms(@NotNull Matrix4d base, String bone) {
        List<PositionalBone> tree = this.parentTree.get(bone);
        if (tree == null || tree.isEmpty()) {
            return false;
        }
        for (PositionalBone f : tree) {
            f.applyTransforms(base);
        }
        return true;
    }

    @Override
    public boolean applyLocatorTransforms(@NotNull Matrix4f base, String locator) {
        PositionalBone bone = this.locatorSources.get(locator);
        if (bone == null) {
            return false;
        }
        GeometryLocator loc = bone.getLocators().get(locator);
        if (loc == null) {
            return false;
        }
        if (this.applyBoneTransforms(base, bone.boxName)) {
            Vector3f offset = loc.getOffset();
            Vector3f rotation = loc.getRotation();
            base.translate(offset.x() / 16.0f, offset.y() / 16.0f, offset.z() / 16.0f);
            if (rotation.x() != 0.0f || rotation.y() != 0.0f || rotation.z() != 0.0f) {
                base.rotate((Quaternionfc)new Quaternionf().rotateZYX(rotation.z(), rotation.y(), rotation.x()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyLocatorTransforms(@NotNull Matrix4d base, String locator) {
        PositionalBone bone = this.locatorSources.get(locator);
        if (bone == null) {
            return false;
        }
        GeometryLocator loc = bone.getLocators().get(locator);
        if (loc == null) {
            return false;
        }
        if (this.applyBoneTransforms(base, bone.boxName)) {
            Vector3f offset = loc.getOffset();
            Vector3f rotation = loc.getRotation();
            base.translate((double)(offset.x() / 16.0f), (double)(offset.y() / 16.0f), (double)(offset.z() / 16.0f));
            if (rotation.x() != 0.0f || rotation.y() != 0.0f || rotation.z() != 0.0f) {
                base.rotate((Quaterniondc)new Quaterniond().rotateZYX((double)rotation.z(), (double)rotation.y(), (double)rotation.x()));
            }
            return true;
        }
        return false;
    }

    public static class PositionalBone
    implements IBone {
        public final String boxName;
        protected PositionalBone parent;
        private final Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
        public Vector3f offset = new Vector3f();
        private final Vector3f startRotationRadians;
        private final Vector3f rotation;
        private final Map<String, PositionalBone> children;
        private final Map<String, GeometryLocator> locators;
        public float offsetX;
        public float offsetY;
        public float offsetZ;

        public PositionalBone(String name, Vector3f startRotRadians, Map<String, PositionalBone> children, Map<String, GeometryLocator> locators) {
            this.boxName = name;
            this.startRotationRadians = startRotRadians;
            this.rotation = new Vector3f((Vector3fc)startRotRadians);
            this.children = Collections.unmodifiableMap(children);
            this.locators = Collections.unmodifiableMap(locators);
            for (PositionalBone p : children.values()) {
                p.parent = this;
            }
        }

        @Override
        public PositionalBone getParent() {
            return this.parent;
        }

        @Override
        public String getName() {
            return this.boxName;
        }

        @Override
        public Vector3f getTranslation() {
            return this.offset;
        }

        @Override
        public Vector3f getRotation() {
            return this.rotation;
        }

        @Override
        public Vector3f getScale() {
            return this.scale;
        }

        public void setPos(float x, float y, float z) {
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
        }

        public Map<String, PositionalBone> getChildren() {
            return this.children;
        }

        @Override
        public Map<String, GeometryLocator> getLocators() {
            return this.locators;
        }

        @Override
        public void reset() {
            this.rotation.set(this.startRotationRadians.x, this.startRotationRadians.y, this.startRotationRadians.z);
            this.offset.set(0.0f, 0.0f, 0.0f);
            this.scale.set(1.0f, 1.0f, 1.0f);
        }

        public void applyTransforms(Matrix4f pose) {
            pose.translate(-this.offset.x() / 16.0f, -this.offset.y() / 16.0f, this.offset.z() / 16.0f);
            pose.translate(this.offsetX / 16.0f, this.offsetY / 16.0f, this.offsetZ / 16.0f);
            if (this.rotation.x() != 0.0f || this.rotation.y() != 0.0f || this.rotation.z() != 0.0f) {
                pose.rotateZYX(this.rotation.z(), this.rotation.y(), this.rotation.x());
            }
            if (this.scale.x() != 1.0f || this.scale.y() != 1.0f || this.scale.z() != 1.0f) {
                pose.scale(this.scale.x(), this.scale.y(), this.scale.z());
            }
        }

        public void applyTransforms(Matrix4d pose) {
            pose.translate((double)(-this.offset.x() / 16.0f), (double)(-this.offset.y() / 16.0f), (double)(this.offset.z() / 16.0f));
            pose.translate((double)(this.offsetX / 16.0f), (double)(this.offsetY / 16.0f), (double)(this.offsetZ / 16.0f));
            if (this.rotation.x() != 0.0f || this.rotation.y() != 0.0f || this.rotation.z() != 0.0f) {
                pose.rotateZYX((double)this.rotation.z(), (double)this.rotation.y(), (double)this.rotation.x());
            }
            if (this.scale.x() != 1.0f || this.scale.y() != 1.0f || this.scale.z() != 1.0f) {
                pose.scale((double)this.scale.x(), (double)this.scale.y(), (double)this.scale.z());
            }
        }
    }
}

