/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.geometry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.geometry.IGeometryContainer;
import org.zeith.hammeranims.api.geometry.data.IGeometryData;
import org.zeith.hammeranims.api.geometry.model.IGeometricModel;
import org.zeith.hammeranims.api.geometry.model.IPositionalModel;
import org.zeith.hammeranims.core.client.model.ModelBoneF;
import org.zeith.hammeranims.core.impl.api.geometry.PositionalModelImpl;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelMaterialInfo;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelMeshInfo;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.ModelPartInfo;

public class GeometryDataImpl
implements IGeometryData {
    protected final IGeometryContainer container;
    protected final ModelMeshInfo mesh;
    protected final ModelMaterialInfo material;
    protected final Map<String, ModelPartInfo> bones = new HashMap<String, ModelPartInfo>();
    protected final PositionalModelImpl positionalModel;

    private GeometryDataImpl(IGeometryContainer container, ModelMeshInfo mesh, ModelMaterialInfo material) {
        this.container = container;
        this.mesh = mesh;
        this.material = material;
        this.registerBone(mesh.getRoot());
        this.positionalModel = PositionalModelImpl.create(container, mesh);
    }

    protected void registerBone(ModelPartInfo part) {
        this.bones.put(part.getName(), part);
        part.getChildren().forEach(this::registerBone);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelBoneF bakeRoot() {
        return this.mesh.getRoot().bake(null, this.material.getTextureWidth(), this.material.getTextureHeight());
    }

    public static GeometryDataImpl create(IGeometryContainer container, ModelMeshInfo mesh, int texWidth, int texHeight) {
        return new GeometryDataImpl(container, mesh, new ModelMaterialInfo(texWidth, texHeight));
    }

    @Override
    public int getTextureWidth() {
        return this.material.getTextureWidth();
    }

    @Override
    public int getTextureHeight() {
        return this.material.getTextureHeight();
    }

    @Override
    public Set<String> getBones() {
        return this.bones.keySet();
    }

    @Override
    public IGeometricModel createModel() {
        return HammerAnimations.PROXY.createGeometryData(this);
    }

    @Override
    public IPositionalModel getPositionalModel() {
        this.positionalModel.resetPose();
        return this.positionalModel;
    }

    @Override
    public IGeometryContainer getContainer() {
        return this.container;
    }
}

