/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.geometry;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.geometry.IGeometryContainer;
import org.zeith.hammeranims.api.geometry.constrains.IGeometryConstraints;
import org.zeith.hammeranims.api.geometry.data.IGeometryData;
import org.zeith.hammeranims.api.geometry.event.DecodeGeometryEvent;
import org.zeith.hammeranims.api.utils.IResourceProvider;
import org.zeith.hammeranims.core.impl.api.geometry.constrains.BoneConstraintsImpl;
import org.zeith.hammeranims.core.impl.api.geometry.constrains.GeometryConstrainsImpl;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.GsonGeometryDecoder;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class GeometryContainerImpl
implements IGeometryContainer {
    protected GeometryConstrainsImpl constraints = new GeometryConstrainsImpl(Collections.emptyMap());
    protected IGeometryData geometry = IGeometryData.EMPTY(this);
    public final String suffix;
    public final String constraintsSuffix;

    public GeometryContainerImpl(String suffix) {
        this.constraintsSuffix = ".constraints.json";
        this.suffix = suffix;
    }

    public GeometryContainerImpl() {
        this.constraintsSuffix = ".constraints.json";
        this.suffix = ".geo.json";
    }

    public static Optional<IGeometryData> defaultReadGeometry(ResourceLocation path, IResourceProvider resources, IGeometryContainer container, Optional<String> text) {
        return text.map(txt -> {
            ResourceLocation key = container.getRegistryKey();
            try {
                Supplier json = Suppliers.memoize(() -> (JSONObject)new JSONTokener(txt).nextValue());
                Supplier geometry = Suppliers.memoize(() -> GeometryContainerImpl.lambda$defaultReadGeometry$1((java.util.function.Supplier)json));
                Supplier fmt = Suppliers.memoize(() -> GeometryContainerImpl.lambda$defaultReadGeometry$2((java.util.function.Supplier)json));
                DecodeGeometryEvent evt = new DecodeGeometryEvent(path, resources, container, (java.util.function.Supplier<JSONObject>)json, (java.util.function.Supplier<String>)fmt, (java.util.function.Supplier<Object>)geometry, (String)txt);
                HammerAnimationsApi.EVENT_BUS.post((Event)evt);
                return evt.getDecoded();
            }
            catch (Exception e) {
                HammerAnimations.LOG.error("Failed to load geometry " + key + ", skipping.", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public void reload(IResourceProvider resources) {
        boolean constraintsLoaded;
        ResourceLocation key = this.getRegistryKey();
        ResourceLocation path = new ResourceLocation(key.m_135827_(), "bedrock/geometry/" + key.m_135815_() + this.suffix);
        ResourceLocation constraintsPath = new ResourceLocation(key.m_135827_(), "bedrock/geometry/" + key.m_135815_() + this.constraintsSuffix);
        this.geometry = Optional.ofNullable(GeometryContainerImpl.defaultReadGeometry(path, resources, this, resources.readAsString(path)).orElseGet(() -> {
            HammerAnimations.LOG.warn("Unable to load geometry {} from file {}", (Object)key, (Object)path);
            return null;
        })).orElse(IGeometryData.EMPTY(this));
        this.constraints = resources.readAsString(constraintsPath).map(GsonGeometryDecoder::readGeometryConstraints).orElse(null);
        boolean bl = constraintsLoaded = this.constraints != null;
        if (this.constraints == null) {
            ImmutableMap.Builder bones = ImmutableMap.builder();
            for (String bone : this.geometry.getBones()) {
                bones.put((Object)bone, (Object)new BoneConstraintsImpl());
            }
            this.constraints = new GeometryConstrainsImpl((Map<String, BoneConstraintsImpl>)bones.build());
        }
        if (HammerAnimationsApi.LOG_RELOADS) {
            HammerAnimations.LOG.debug("Loaded {} geometry with {} bones{}.", (Object)key, (Object)this.geometry.getBones().size(), constraintsLoaded ? " and " + this.constraints.bones().size() + " constraints" : "");
        }
    }

    @Override
    public IGeometryData getGeometry() {
        return this.geometry;
    }

    @Override
    @Nonnull
    public IGeometryConstraints getConstraints() {
        return this.constraints;
    }

    private static /* synthetic */ String lambda$defaultReadGeometry$2(java.util.function.Supplier json) {
        return ((JSONObject)json.get()).getString("format_version");
    }

    private static /* synthetic */ Object lambda$defaultReadGeometry$1(java.util.function.Supplier json) {
        return ((JSONObject)json.get()).get("minecraft:geometry");
    }
}

