/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.animation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.animation.Animation;
import org.zeith.hammeranims.api.animation.data.IReadAnimationHolder;

public class ReadAnimationHolderImpl
implements IReadAnimationHolder {
    protected Map<String, Animation> animations = this.createAnimationMap();
    protected Map<String, Animation> animationsView = Collections.unmodifiableMap(this.animations);
    protected final ResourceLocation key;

    public ReadAnimationHolderImpl(ResourceLocation key) {
        this.key = key;
    }

    protected Map<String, Animation> createAnimationMap() {
        return new LinkedHashMap<String, Animation>();
    }

    public void put(String key, Animation anim) {
        if (anim == null) {
            HammerAnimations.LOG.warn("Failed to decode animation " + key + " in " + this.key);
            return;
        }
        this.animations.put(key, anim);
    }

    @Override
    public Set<String> getKeySet() {
        return this.animationsView.keySet();
    }

    @Override
    public Animation get(String key) {
        return this.animations.get(key);
    }

    @Override
    public Set<Map.Entry<String, Animation>> entrySet() {
        return this.animationsView.entrySet();
    }

    @Override
    public Collection<Animation> values() {
        return this.animationsView.values();
    }
}

