/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.animation;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.animation.Animation;
import org.zeith.hammeranims.api.animation.AnimationLocation;
import org.zeith.hammeranims.api.animation.LoopMode;
import org.zeith.hammeranims.api.animation.data.BoneAnimation;
import org.zeith.hammeranims.api.animation.data.IAnimationData;
import org.zeith.hammeranims.api.animation.data.effects.AnimatedParticleEffect;
import org.zeith.hammeranims.api.animation.data.effects.AnimatedSoundEffect;
import org.zeith.hammeranims.api.animation.event.DecodeAnimationEvent;
import org.zeith.hammeranims.core.init.DefaultsHA;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public class AnimationDecoder {
    public static void init() {
    }

    public static void decodeAnimation(DecodeAnimationEvent e) {
        JSONObject particleEffectsObj;
        String modeStr;
        LoopMode modeRaw;
        if (e.container == DefaultsHA.NULL_ANIMATION) {
            e.setDecoded(DefaultsHA.NULL_ANIMATION_SYNTETIC);
            return;
        }
        JSONObject obj = e.asObject().orElse(null);
        if (obj == null) {
            return;
        }
        if (!obj.has("bones")) {
            return;
        }
        AnimationLocation loc = new AnimationLocation(e.container.getRegistryKey(), e.key);
        if (!"1.8.0".equals(e.formatVersion)) {
            loc.warn("Potentially unsupported version of animation: {}; We support 1.8.0. Potential incompatibility may arise!", e.formatVersion);
        }
        Object o = obj.opt("loop");
        float weight = 1.0f;
        String blend_weight = obj.optString("blend_weight", "");
        if (blend_weight != null && !blend_weight.isEmpty()) {
            try {
                weight = (float)Double.parseDouble(blend_weight);
            }
            catch (Exception err) {
                loc.warn("Found blend_weight: \"{}\", but it's unable to be parsed as a number.", JSONObject.quote((String)blend_weight));
            }
        }
        final float fweight = weight;
        LoopMode loopMode = modeRaw = o instanceof Boolean && (Boolean)o != false ? LoopMode.LOOP : LoopMode.ONCE;
        if (o instanceof String && (modeStr = (String)o).equalsIgnoreCase("hold_on_last_frame")) {
            modeRaw = LoopMode.HOLD_ON_LAST_FRAME;
        }
        final Duration time = Duration.ofMillis(Math.round(obj.optDouble("animation_length") * 1000.0));
        HashMap<String, BoneAnimation> bones = new HashMap<String, BoneAnimation>();
        JSONObject bonesObj = obj.getJSONObject("bones");
        for (String boneKey : bonesObj.keySet()) {
            BoneAnimation parse = BoneAnimation.parse(loc, bonesObj.getJSONObject(boneKey));
            if (parse == null) {
                loc.warn("Unable to parse bone {}, skipping.", boneKey);
                continue;
            }
            bones.put(boneKey, parse);
        }
        JSONObject soundEffectsObj = obj.optJSONObject("sound_effects");
        Int2ObjectOpenHashMap soundEffects = new Int2ObjectOpenHashMap(soundEffectsObj != null ? soundEffectsObj.length() : 0);
        if (soundEffectsObj != null) {
            for (String key : soundEffectsObj.keySet()) {
                Duration timestamp;
                try {
                    double seconds = Double.parseDouble(key);
                    timestamp = Duration.ofMillis((long)(seconds *= 1000.0));
                }
                catch (NumberFormatException err) {
                    loc.warn("Unable to decode sound_effects keyframe '{}' (must be a double)", key);
                    continue;
                }
                soundEffects.put((int)(timestamp.toMillis() / 50L), AnimatedSoundEffect.decode(soundEffectsObj.opt(key)));
            }
        }
        Int2ObjectOpenHashMap particleEffects = new Int2ObjectOpenHashMap((particleEffectsObj = obj.optJSONObject("particle_effects")) != null ? particleEffectsObj.length() : 0);
        if (particleEffectsObj != null) {
            for (String key : particleEffectsObj.keySet()) {
                Duration timestamp;
                try {
                    double seconds = Double.parseDouble(key);
                    timestamp = Duration.ofMillis((long)(seconds *= 1000.0));
                }
                catch (NumberFormatException err) {
                    loc.warn("Unable to decode sound_effects keyframe '{}' (must be a double)", key);
                    continue;
                }
                particleEffects.put((int)(timestamp.toMillis() / 50L), AnimatedParticleEffect.decode(particleEffectsObj.opt(key)));
            }
        }
        final LoopMode mode = modeRaw;
        final Map bonesView = Collections.unmodifiableMap(bones);
        final Int2ObjectMap soundEffectsView = Int2ObjectMaps.unmodifiable((Int2ObjectMap)soundEffects);
        final Int2ObjectMap particleEffectsView = Int2ObjectMaps.unmodifiable((Int2ObjectMap)particleEffects);
        e.setDecoded(new Animation(e.container, e.key, new IAnimationData(){

            @Override
            public LoopMode getLoopMode() {
                return mode;
            }

            @Override
            public Duration getLength() {
                return time;
            }

            @Override
            public Map<String, BoneAnimation> getBoneAnimations() {
                return bonesView;
            }

            @Override
            public Int2ObjectMap<List<AnimatedSoundEffect>> getSoundEffects() {
                return soundEffectsView;
            }

            @Override
            public Int2ObjectMap<List<AnimatedParticleEffect>> getParticleEffects() {
                return particleEffectsView;
            }

            @Override
            public float getWeight() {
                return fweight;
            }

            public String toString() {
                return "IAnimationData{loop_mode=" + mode + ",duration=" + (float)time.toMillis() / 1000.0f + ",bones=" + bonesView + ",weight=" + fweight + "}";
            }
        }));
    }

    static {
        HammerAnimationsApi.EVENT_BUS.addListener(AnimationDecoder::decodeAnimation);
    }
}

