/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.impl.api.animation;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.animation.Animation;
import org.zeith.hammeranims.api.animation.AnimationHolder;
import org.zeith.hammeranims.api.animation.AnimationLocation;
import org.zeith.hammeranims.api.animation.IAnimationContainer;
import org.zeith.hammeranims.api.animation.data.IReadAnimationHolder;
import org.zeith.hammeranims.api.animation.event.AnimationContainerParseEvent;
import org.zeith.hammeranims.api.animation.event.DecodeAnimationEvent;
import org.zeith.hammeranims.api.utils.IResourceProvider;
import org.zeith.hammeranims.core.impl.api.animation.ReadAnimationHolderImpl;
import org.zeith.hammeranims.core.init.DefaultsHA;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class AnimationContainerImpl
implements IAnimationContainer {
    protected IReadAnimationHolder animations = IReadAnimationHolder.EMPTY;
    public final String suffix;
    protected Animation defaultAnimation;
    protected final AnimationHolder onlyHolder = new AnimationHolder(this, "default"){

        @Override
        @Nonnull
        public Animation get() {
            Animation animation = AnimationContainerImpl.this.defaultAnimation;
            if (animation == null) {
                return DefaultsHA.NULL_ANIMATION_SYNTETIC;
            }
            return animation;
        }

        @Override
        public AnimationLocation getLocation() {
            return this.get().getLocation();
        }
    };

    public AnimationContainerImpl(String suffix) {
        this.suffix = suffix;
    }

    public AnimationContainerImpl() {
        this.suffix = ".animation.json";
    }

    public static Optional<IReadAnimationHolder> defaultReadAnimation(IResourceProvider resources, IAnimationContainer container, Optional<String> text) {
        return text.map(JSONTokener::new).flatMap(JSONTokener::nextValueOBJ).map(json -> {
            ResourceLocation key = container.getRegistryKey();
            try {
                ReadAnimationHolderImpl holder = new ReadAnimationHolderImpl(key);
                JSONObject animations = json.getJSONObject("animations");
                String fmt = json.getString("format_version");
                for (String animKey : animations.keySet()) {
                    DecodeAnimationEvent evt = new DecodeAnimationEvent(resources, container, (JSONObject)json, fmt, animKey, animations.get(animKey));
                    if (!evt.isCanceled()) {
                        HammerAnimationsApi.EVENT_BUS.post((Event)evt);
                    }
                    holder.put(animKey, evt.getDecoded());
                }
                return holder;
            }
            catch (Exception e) {
                HammerAnimations.LOG.error("Failed to load animation " + key + ", skipping.", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public void reload(IResourceProvider resources) {
        ResourceLocation key = this.getRegistryKey();
        ResourceLocation path = new ResourceLocation(key.m_135827_(), "bedrock/animations/" + key.m_135815_() + this.suffix);
        AnimationContainerParseEvent event = new AnimationContainerParseEvent(resources, path, this);
        HammerAnimationsApi.EVENT_BUS.post((Event)event);
        this.animations = Optional.ofNullable(event.getOverrideOrDefault(() -> AnimationContainerImpl.defaultReadAnimation(resources, this, resources.readAsString(path)).orElseGet(() -> {
            HammerAnimations.LOG.warn("Unable to load animation {} from file {}", (Object)key, (Object)path);
            return null;
        }))).orElse(IReadAnimationHolder.EMPTY);
        Collection<Animation> anims = this.animations.values();
        this.defaultAnimation = anims.size() == 1 ? anims.iterator().next() : DefaultsHA.NULL_ANIMATION_SYNTETIC;
        if (HammerAnimationsApi.LOG_RELOADS) {
            HammerAnimations.LOG.debug("Loaded {} animations in {}: {}", (Object)this.animations.getKeySet().size(), (Object)key, this.animations.getKeySet());
        }
    }

    @Override
    public IReadAnimationHolder getAnimations() {
        return this.animations;
    }

    @Override
    @Nonnull
    public AnimationHolder holder() {
        return this.onlyHolder;
    }

    public String toString() {
        return IAnimationContainer.class.getSimpleName() + "{" + this.getRegistryKey() + "}";
    }
}

