/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.time;

import java.time.Duration;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammeranims.api.animsys.AnimationSystem;
import org.zeith.hammeranims.api.animsys.layer.ActiveAnimation;
import org.zeith.hammeranims.api.time.TimeFunction;
import org.zeith.hammeranims.api.time.TimeFunctionInstance;
import org.zeith.hammeranims.core.contents.time.LinearTimeFunction;

public class NormalizedTimeFunction
extends LinearTimeFunction {
    @Override
    public double computeTime(AnimationSystem system, double sysTime, float partialTicks, ActiveAnimation animation, TimeFunctionInstance instance) {
        double rawTime = super.computeTime(system, sysTime, partialTicks, animation, instance);
        double originalDuration = super.getLengthSeconds(animation, instance);
        double remappedDuration = this.getLengthSeconds(animation, instance);
        return rawTime * originalDuration / remappedDuration;
    }

    @Override
    public double getLengthSeconds(ActiveAnimation animation, TimeFunctionInstance instance) {
        return instance instanceof Instance ? ((Instance)instance).duration : super.getLengthSeconds(animation, instance);
    }

    @Override
    @NotNull
    protected TimeFunctionInstance createInstance() {
        return new Instance(this, 1.0);
    }

    public Instance of(double duration) {
        return new Instance(this, duration);
    }

    public Instance of(Duration duration) {
        return this.of((double)duration.toMillis() / 1000.0);
    }

    public static class Instance
    extends TimeFunctionInstance {
        protected double duration;

        public Instance(TimeFunction function, double duration) {
            super(function);
            this.duration = duration;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128347_("NDuration", this.duration);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.duration = nbt.m_128459_("NDuration");
        }
    }
}

