/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.particles.components.shape;

import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.api.particles.emitter.BedrockParticle;
import org.zeith.hammeranims.api.particles.variables.ParticleVariables;

public abstract class ShapeDirection {
    public static final ShapeDirection INWARDS = new Inwards(-1.0f);
    public static final ShapeDirection OUTWARDS = new Inwards(1.0f);

    public abstract void applyDirection(BedrockParticle var1, double var2, double var4, double var6);

    private static class Inwards
    extends ShapeDirection {
        private float factor;

        public Inwards(float factor) {
            this.factor = factor;
        }

        @Override
        public void applyDirection(BedrockParticle particle, double x, double y, double z) {
            Vector3d vector = new Vector3d((Vector3dc)particle.position);
            vector.sub((Vector3dc)new Vector3d(x, y, z));
            if (vector.length() <= 0.0) {
                vector.set(0.0, 0.0, 0.0);
            } else {
                vector.normalize();
                vector.mul((double)this.factor);
            }
            particle.speed.set((Vector3dc)vector);
        }
    }

    public static class Vector
    extends ShapeDirection {
        public InterpolatedDouble<ParticleVariables> x;
        public InterpolatedDouble<ParticleVariables> y;
        public InterpolatedDouble<ParticleVariables> z;

        public Vector(InterpolatedDouble<ParticleVariables> x, InterpolatedDouble<ParticleVariables> y, InterpolatedDouble<ParticleVariables> z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public void applyDirection(BedrockParticle particle, double x, double y, double z) {
            ParticleVariables v = particle.owner.vars;
            particle.speed.set((float)this.x.get(v), (float)this.y.get(v), (float)this.z.get(v));
            if (particle.speed.length() <= 0.0f) {
                particle.speed.set(0.0f, 0.0f, 0.0f);
            } else {
                particle.speed.normalize();
            }
        }
    }
}

