/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.particles.components.shape;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.api.particles.emitter.BedrockParticle;
import org.zeith.hammeranims.api.particles.emitter.ParticleEmitter;
import org.zeith.hammeranims.api.particles.variables.ParticleVariables;
import org.zeith.hammeranims.core.contents.particles.components.shape.ParcomShapeSphere;

public class ParcomShapeDisc
extends ParcomShapeSphere {
    public InterpolatedDouble[] normal = new InterpolatedDouble[]{InterpolatedDouble.zero(), InterpolatedDouble.one(), InterpolatedDouble.zero()};

    public ParcomShapeDisc(JsonElement elem) {
        super(elem);
        if (!elem.isJsonObject()) {
            return;
        }
        JsonObject element = elem.getAsJsonObject();
        if (!element.has("plane_normal")) {
            return;
        }
        JsonElement normal = element.get("plane_normal");
        if (normal.isJsonPrimitive()) {
            String axis = normal.getAsString().toLowerCase();
            if (axis.equals("x")) {
                this.normal[0] = InterpolatedDouble.one();
                this.normal[1] = InterpolatedDouble.zero();
            } else if (axis.equals("z")) {
                this.normal[1] = InterpolatedDouble.zero();
                this.normal[2] = InterpolatedDouble.one();
            }
        } else {
            JsonArray array = element.getAsJsonArray("plane_normal");
            if (array.size() >= 3) {
                this.normal[0] = InterpolatedDouble.parse(array.get(0));
                this.normal[1] = InterpolatedDouble.parse(array.get(1));
                this.normal[2] = InterpolatedDouble.parse(array.get(2));
            }
        }
    }

    @Override
    public void apply(ParticleEmitter emitter, BedrockParticle particle) {
        ParticleVariables v = emitter.vars;
        float centerX = (float)this.offset[0].get(v);
        float centerY = (float)this.offset[1].get(v);
        float centerZ = (float)this.offset[2].get(v);
        Vector3f normal = new Vector3f((float)this.normal[0].get(v), (float)this.normal[1].get(v), (float)this.normal[2].get(v));
        normal.normalize();
        Quaternionf quaternion = new Quaternionf(normal.x, normal.y, normal.z, 1.0f);
        Matrix4f rotation = new Matrix4f();
        rotation.set((Quaternionfc)quaternion);
        Vector4f position = new Vector4f((float)Math.random() - 0.5f, 0.0f, (float)Math.random() - 0.5f, 0.0f);
        position.normalize();
        rotation.transform(position);
        position.mul((float)(this.radius.get(v) * (this.surface ? 1.0 : Math.random())));
        position.add((Vector4fc)new Vector4f(centerX, centerY, centerZ, 0.0f));
        particle.position.x += (double)position.x;
        particle.position.y += (double)position.y;
        particle.position.z += (double)position.z;
        this.direction.applyDirection(particle, centerX, centerY, centerZ);
    }
}

