/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.particles.components.shape;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.api.particles.components.itf.IParticleInitialize;
import org.zeith.hammeranims.core.contents.particles.components.shape.ShapeDirection;

public abstract class ParcomShapeBase
implements IParticleInitialize {
    public InterpolatedDouble[] offset = new InterpolatedDouble[]{InterpolatedDouble.zero(), InterpolatedDouble.zero(), InterpolatedDouble.zero()};
    public ShapeDirection direction = ShapeDirection.OUTWARDS;
    public boolean surface = false;

    public ParcomShapeBase(JsonElement elem) {
        JsonArray array;
        if (!elem.isJsonObject()) {
            return;
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("offset") && (array = element.getAsJsonArray("offset")).size() >= 3) {
            this.offset[0] = InterpolatedDouble.parse(array.get(0));
            this.offset[1] = InterpolatedDouble.parse(array.get(1));
            this.offset[2] = InterpolatedDouble.parse(array.get(2));
        }
        if (element.has("direction")) {
            JsonArray array2;
            JsonElement direction = element.get("direction");
            if (direction.isJsonPrimitive()) {
                String name = direction.getAsString();
                this.direction = name.equals("inwards") ? ShapeDirection.INWARDS : ShapeDirection.OUTWARDS;
            } else if (direction.isJsonArray() && (array2 = direction.getAsJsonArray()).size() >= 3) {
                this.direction = new ShapeDirection.Vector(InterpolatedDouble.parse(array2.get(0)), InterpolatedDouble.parse(array2.get(1)), InterpolatedDouble.parse(array2.get(2)));
            }
        }
        if (element.has("surface_only")) {
            this.surface = element.get("surface_only").getAsBoolean();
        }
    }
}

