/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.particles.components.rate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.api.particles.components.itf.IParticlePostRender;
import org.zeith.hammeranims.api.particles.emitter.ParticleEmitter;
import org.zeith.hammeranims.api.particles.variables.ParticleVariables;
import org.zeith.hammeranims.core.contents.particles.components.rate.ParcomRate;

public class ParcomRateSteady
extends ParcomRate
implements IParticlePostRender {
    public static final InterpolatedDouble<ParticleVariables> DEFAULT_PARTICLES = InterpolatedDouble.constant(50.0);
    public InterpolatedDouble<ParticleVariables> spawnRate = InterpolatedDouble.one();

    public ParcomRateSteady(JsonElement elem) {
        this.particles = DEFAULT_PARTICLES;
        if (!elem.isJsonObject()) {
            return;
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("spawn_rate")) {
            this.spawnRate = InterpolatedDouble.parse(element.get("spawn_rate"));
        }
        if (element.has("max_particles")) {
            this.particles = InterpolatedDouble.parse(element.get("max_particles"));
        }
    }

    @Override
    public void postRender(ParticleEmitter emitter, float partialTicks) {
        double particles;
        double diff;
        double spawn;
        if (emitter.playing && (spawn = (double)Math.round(diff = (particles = emitter.getAge(partialTicks) * this.spawnRate.get(emitter.vars)) - emitter.spawnedParticles)) > 0.0) {
            emitter.setEmitterVariables(partialTicks);
            double track = spawn;
            int i = 0;
            while ((double)i < spawn) {
                if ((double)emitter.particles.size() < this.particles.get(emitter.vars)) {
                    emitter.spawnParticle();
                } else {
                    track -= 1.0;
                }
                ++i;
            }
            emitter.spawnedParticles += track;
        }
    }

    @Override
    public int getSortingIndex() {
        return 10;
    }
}

