/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.particles.components.motion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.api.particles.components.itf.IParticleUpdate;
import org.zeith.hammeranims.api.particles.emitter.BedrockParticle;
import org.zeith.hammeranims.api.particles.emitter.ParticleEmitter;
import org.zeith.hammeranims.api.particles.variables.ParticleVariables;
import org.zeith.hammeranims.core.utils.EntityTransformationUtils;
import org.zeith.hammeranims.core.utils.EnumFacing;
import org.zeith.hammeranims.joml.Math;

public class ParcomMotionCollision
implements IParticleUpdate {
    public InterpolatedDouble<ParticleVariables> enabled = InterpolatedDouble.one();
    public boolean preserveEnergy = false;
    public boolean entityCollision;
    public boolean momentum;
    public float collisionDrag = 0.0f;
    public float bounciness = 1.0f;
    public float randomBounciness = 0.0f;
    public float randomDamp = 0.0f;
    public float damp = 0.0f;
    public int splitParticleCount;
    public float splitParticleSpeedThreshold;
    public float radius = 0.01f;
    public boolean expireOnImpact;
    public InterpolatedDouble<ParticleVariables> expirationDelay = InterpolatedDouble.zero();
    public boolean realisticCollision;
    public boolean realisticCollisionDrag;
    public float rotationCollisionDrag;
    private Vector3d previous = new Vector3d();
    private Vector3d current = new Vector3d();
    private BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    public ParcomMotionCollision(JsonElement elem) {
        if (!elem.isJsonObject()) {
            return;
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("enabled")) {
            this.enabled = InterpolatedDouble.parse(element.get("enabled"));
        }
        if (element.has("entityCollision")) {
            this.entityCollision = element.get("entityCollision").getAsBoolean();
        }
        if (element.has("momentum")) {
            this.momentum = element.get("momentum").getAsBoolean();
        }
        if (element.has("realistic_collision_drag")) {
            this.realisticCollisionDrag = element.get("realistic_collision_drag").getAsBoolean();
        }
        if (element.has("collision_drag")) {
            this.collisionDrag = element.get("collision_drag").getAsFloat();
        }
        if (element.has("coefficient_of_restitution")) {
            this.bounciness = element.get("coefficient_of_restitution").getAsFloat();
        }
        if (element.has("bounciness_randomness")) {
            this.randomBounciness = element.get("bounciness_randomness").getAsFloat();
        }
        if (element.has("collision_rotation_drag")) {
            this.rotationCollisionDrag = element.get("collision_rotation_drag").getAsFloat();
        }
        if (element.has("preserveEnergy") && element.get("preserveEnergy").isJsonPrimitive()) {
            JsonPrimitive energy = element.get("preserveEnergy").getAsJsonPrimitive();
            if (energy.isBoolean()) {
                this.preserveEnergy = energy.getAsBoolean();
            } else {
                boolean bl = this.preserveEnergy = energy.getAsNumber().longValue() > 0L;
            }
        }
        if (element.has("damp")) {
            this.damp = element.get("damp").getAsFloat();
        }
        if (element.has("random_damp")) {
            this.randomDamp = element.get("random_damp").getAsFloat();
        }
        if (element.has("split_particle_count")) {
            this.splitParticleCount = element.get("split_particle_count").getAsInt();
        }
        if (element.has("split_particle_speedThreshold")) {
            this.splitParticleSpeedThreshold = element.get("split_particle_speedThreshold").getAsFloat();
        }
        if (element.has("collision_radius")) {
            this.radius = element.get("collision_radius").getAsFloat();
        }
        if (element.has("expire_on_contact")) {
            this.expireOnImpact = element.get("expire_on_contact").getAsBoolean();
        }
        if (element.has("expirationDelay")) {
            this.expirationDelay = InterpolatedDouble.parse(element.get("expirationDelay"));
        }
        if (element.has("realisticCollision")) {
            this.realisticCollision = element.get("realisticCollision").getAsBoolean();
        }
    }

    @Override
    public void update(ParticleEmitter emitter, BedrockParticle particle) {
        particle.realisticCollisionDrag = this.realisticCollisionDrag;
        if (emitter.world == null) {
            return;
        }
        float r = this.radius;
        this.previous.set((Vector3dc)particle.getGlobalPosition(emitter, particle.prevPosition));
        this.current.set((Vector3dc)particle.getGlobalPosition(emitter));
        Vector3d prev = this.previous;
        Vector3d now = this.current;
        double x = now.x - prev.x;
        double y = now.y - prev.y;
        double z = now.z - prev.z;
        boolean veryBig = java.lang.Math.abs(x) > 10.0 || java.lang.Math.abs(y) > 10.0 || java.lang.Math.abs(z) > 10.0;
        this.pos.m_122169_(now.x, now.y, now.z);
        if (veryBig || !emitter.world.m_46749_((BlockPos)this.pos)) {
            return;
        }
        AABB aabb = new AABB(prev.x - (double)r, prev.y - (double)r, prev.z - (double)r, prev.x + (double)r, prev.y + (double)r, prev.z + (double)r);
        double d0 = y;
        double origX = x;
        double origZ = z;
        List entities = emitter.world.m_45976_(Entity.class, aabb.m_82377_(x, y, z));
        HashMap<Entity, AABB> entityAABBs = new HashMap<Entity, AABB>();
        HashMap<Entity, CollisionOffset> staticEntityAABBs = new HashMap<Entity, CollisionOffset>();
        List<AABB> list = BlockPos.m_121921_((AABB)aabb.m_82377_(x, y, z)).flatMap(pos -> emitter.world.m_8055_(pos).m_60812_((BlockGetter)emitter.world, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_83299_().stream()).collect(Collectors.toList());
        if ((!list.isEmpty() || !entities.isEmpty() && this.entityCollision) && !particle.intersected) {
            particle.firstIntersection = particle.age;
            particle.intersected = true;
        }
        if (!particle.manual && this.enabled.get(emitter.vars) > 0.0) {
            AABB entityAABB;
            if (this.entityCollision) {
                for (Entity entity : entities) {
                    AABB aabb2 = new AABB(prev.x - (double)r, prev.y - (double)r, prev.z - (double)r, prev.x + (double)r, prev.y + (double)r, prev.z + (double)r);
                    entityAABB = entity.m_20191_();
                    double y2 = y;
                    double x2 = x;
                    double z2 = z;
                    y2 = ParcomMotionCollision.calculateYOffset(entityAABB, aabb2, y2);
                    aabb2 = aabb2.m_82386_(0.0, y2, 0.0);
                    x2 = ParcomMotionCollision.calculateXOffset(entityAABB, aabb2, x2);
                    aabb2 = aabb2.m_82386_(x2, 0.0, 0.0);
                    z2 = ParcomMotionCollision.calculateZOffset(entityAABB, aabb2, z2);
                    aabb2 = aabb2.m_82386_(0.0, 0.0, z2);
                    if (d0 == y2 && origX == x2 && origZ == z2) {
                        entityAABBs.put(entity, entityAABB);
                        continue;
                    }
                    list.add(entityAABB);
                    staticEntityAABBs.put(entity, new CollisionOffset(entityAABB, x2, y2, z2));
                    if (!this.momentum || d0 != y2) continue;
                    this.momentum(particle, entity);
                }
            }
            CollisionOffset offsetData = this.calculateOffsets(aabb, list, x, y, z);
            aabb = offsetData.aabb;
            x = offsetData.x;
            y = offsetData.y;
            z = offsetData.z;
            if (d0 != y || origX != x || origZ != z) {
                this.collision(particle, emitter, prev);
                now.set(aabb.f_82288_ + (double)r, aabb.f_82289_ + (double)r, aabb.f_82290_ + (double)r);
                if (d0 != y) {
                    now.y = d0 < y ? aabb.f_82289_ : aabb.f_82292_;
                    now.y = now.y + (d0 < y ? (double)r : (double)(-r));
                    this.collisionHandler(particle, emitter, EnumFacing.Axis.Y, now, prev);
                    particle.entityCollisionTime.keySet().retainAll(staticEntityAABBs.keySet());
                    for (Map.Entry entry : staticEntityAABBs.entrySet()) {
                        CollisionOffset offsetData2 = (CollisionOffset)entry.getValue();
                        AABB entityAABB2 = offsetData2.aabb;
                        Entity collidingEntity = (Entity)entry.getKey();
                        if (d0 != offsetData2.y && origX == offsetData2.x && origZ == offsetData2.z) {
                            this.inertia(particle, collidingEntity, now);
                        }
                        if (particle.entityCollisionTime.containsKey(collidingEntity)) {
                            particle.entityCollisionTime.get((Object)collidingEntity).y = particle.age;
                            continue;
                        }
                        particle.entityCollisionTime.put((Entity)entry.getKey(), new Vector3f(-1.0f, (float)particle.age, -1.0f));
                    }
                }
                if (origX != x) {
                    now.x = origX < x ? aabb.f_82288_ : aabb.f_82291_;
                    now.x = now.x + (origX < x ? (double)r : (double)(-r));
                    this.collisionHandler(particle, emitter, EnumFacing.Axis.X, now, prev);
                }
                if (origZ != z) {
                    now.z = origZ < z ? aabb.f_82290_ : aabb.f_82293_;
                    now.z = now.z + (origZ < z ? (double)r : (double)(-r));
                    this.collisionHandler(particle, emitter, EnumFacing.Axis.Z, now, prev);
                }
                particle.position.set((Vector3dc)now);
                this.drag(particle);
            } else if (entityAABBs.isEmpty() && this.realisticCollisionDrag) {
                particle.dragFactor = 0.0f;
            } else {
                particle.rotationCollisionDrag = 0.0f;
            }
            for (Map.Entry entry : entityAABBs.entrySet()) {
                Vector3f ray;
                Vector3d frac;
                entityAABB = (AABB)entry.getValue();
                Entity entity = (Entity)entry.getKey();
                Vec3 dMove = entity.m_20182_().m_82492_(entity.f_19854_, entity.f_19855_, entity.f_19856_);
                Vector3f speedEntity = new Vector3f((float)dMove.f_82479_, (float)dMove.f_82480_, (float)dMove.f_82481_);
                if (speedEntity.x == 0.0f && speedEntity.y == 0.0f && speedEntity.z == 0.0f || (frac = this.intersect(ray = speedEntity, particle.getGlobalPosition(emitter), entityAABB)) == null) continue;
                particle.position.add((Vector3dc)frac);
                AABB aabb2 = new AABB(particle.position.x - (double)r, particle.position.y - (double)r, particle.position.z - (double)r, particle.position.x + (double)r, particle.position.y + (double)r, particle.position.z + (double)r);
                this.collision(particle, emitter, prev);
                if (aabb2.f_82288_ < entityAABB.f_82291_ && aabb2.f_82291_ > entityAABB.f_82291_ || aabb2.f_82291_ > entityAABB.f_82288_ && aabb2.f_82288_ < entityAABB.f_82288_) {
                    this.entityCollision(particle, emitter, entity, EnumFacing.Axis.X, prev);
                }
                if (aabb2.f_82289_ < entityAABB.f_82292_ && aabb2.f_82292_ > entityAABB.f_82292_ || aabb2.f_82292_ > entityAABB.f_82289_ && aabb2.f_82289_ < entityAABB.f_82289_) {
                    this.entityCollision(particle, emitter, entity, EnumFacing.Axis.Y, prev);
                }
                if (!(aabb2.f_82290_ < entityAABB.f_82293_ && aabb2.f_82293_ > entityAABB.f_82293_) && (!(aabb2.f_82293_ > entityAABB.f_82290_) || !(aabb2.f_82290_ < entityAABB.f_82290_))) continue;
                this.entityCollision(particle, emitter, entity, EnumFacing.Axis.Z, prev);
            }
            if (!entityAABBs.isEmpty()) {
                this.drag(particle);
            }
        }
    }

    public void collision(BedrockParticle particle, ParticleEmitter emitter, Vector3d prev) {
        if (this.expireOnImpact) {
            double expirationDelay = this.expirationDelay.get(emitter.vars);
            if (expirationDelay != 0.0 && !particle.collided) {
                particle.setExpirationDelay(expirationDelay);
            } else if (expirationDelay == 0.0 && !particle.collided) {
                particle.dead = true;
                return;
            }
        }
        if (particle.relativePosition) {
            particle.relativePosition = false;
            particle.prevPosition.set((Vector3dc)prev);
        }
        particle.rotationCollisionDrag = this.rotationCollisionDrag;
        particle.collided = true;
    }

    public void entityCollision(BedrockParticle particle, ParticleEmitter emitter, Entity entity, EnumFacing.Axis component, Vector3d prev) {
        Vec3 ePos = entity.m_20182_();
        Vec3 dMove = ePos.m_82492_(entity.f_19854_, entity.f_19855_, entity.f_19856_);
        Vector3f entitySpeed = new Vector3f((float)dMove.f_82479_, (float)dMove.f_82480_, (float)dMove.f_82481_);
        Vector3d entityPosition = new Vector3d(ePos.f_82479_, ePos.f_82480_, ePos.f_82481_);
        if (this.momentum) {
            this.momentum(particle, entity);
        }
        float tmpTime = ParcomMotionCollision.getComponent(particle.collisionTime, component);
        double delta = ParcomMotionCollision.getComponent(particle.position, component) - ParcomMotionCollision.getComponent(entityPosition, component);
        ParcomMotionCollision.setComponent(particle.position, component, ParcomMotionCollision.getComponent(particle.position, component) + (double)(delta > 0.0 ? this.radius : -this.radius));
        this.collisionHandler(particle, emitter, component, particle.position, prev);
        ParcomMotionCollision.setComponent(particle.collisionTime, component, tmpTime);
        if (delta > 0.0 && component == EnumFacing.Axis.Y) {
            this.inertia(particle, entity, null);
        }
        if (ParcomMotionCollision.getComponent(particle.speed, component) > 0.0f) {
            if (ParcomMotionCollision.getComponent(entitySpeed, component) < 0.0f) {
                ParcomMotionCollision.negateComponent(particle.speed, component);
            }
        } else if (ParcomMotionCollision.getComponent(particle.speed, component) < 0.0f && ParcomMotionCollision.getComponent(entitySpeed, component) > 0.0f) {
            ParcomMotionCollision.negateComponent(particle.speed, component);
        }
        ParcomMotionCollision.setComponent(particle.position, component, ParcomMotionCollision.getComponent(particle.position, component) + (double)(ParcomMotionCollision.getComponent(particle.speed, component) / 20.0f));
    }

    public void collisionHandler(BedrockParticle particle, ParticleEmitter emitter, EnumFacing.Axis component, Vector3d now, Vector3d prev) {
        float collisionTime = ParcomMotionCollision.getComponent(particle.collisionTime, component);
        float speed = ParcomMotionCollision.getComponent(particle.speed, component);
        float accelerationFactor = ParcomMotionCollision.getComponent(particle.accelerationFactor, component);
        if (this.realisticCollision) {
            if (collisionTime != (float)(particle.age - 1)) {
                if (this.bounciness != 0.0f) {
                    ParcomMotionCollision.setComponent(particle.speed, component, -speed * this.bounciness);
                }
            } else if (collisionTime == (float)(particle.age - 1)) {
                ParcomMotionCollision.setComponent(particle.speed, component, 0.0f);
            }
        } else {
            ParcomMotionCollision.setComponent(particle.accelerationFactor, component, accelerationFactor * -this.bounciness);
        }
        if (collisionTime != (float)(particle.age - 1)) {
            if (this.randomBounciness != 0.0f) {
                particle.speed = this.randomBounciness(particle.speed, component, this.randomBounciness);
            }
            if (this.splitParticleCount != 0) {
                this.splitParticle(particle, emitter, component, now, prev);
            }
            if (this.damp != 0.0f) {
                particle.speed = this.damping(particle.speed);
            }
        }
        if (collisionTime != (float)(particle.age - 1)) {
            ++particle.bounces;
        }
        ParcomMotionCollision.setComponent(particle.collisionTime, component, particle.age);
    }

    public void inertia(BedrockParticle particle, Entity entity, @Nullable Vector3d now) {
        if (this.collisionDrag == 0.0f) {
            return;
        }
        Vec3 ePos = entity.m_20182_();
        Vec3 dMove = ePos.m_82492_(entity.f_19854_, entity.f_19855_, entity.f_19856_);
        Vector3f entitySpeed = new Vector3f((float)dMove.f_82479_, (float)dMove.f_82480_, (float)dMove.f_82481_);
        double prevPrevPosX = EntityTransformationUtils.getPrevPrevPosX(entity);
        double prevPrevPosY = EntityTransformationUtils.getPrevPrevPosY(entity);
        double prevPrevPosZ = EntityTransformationUtils.getPrevPrevPosZ(entity);
        Vector3d prevEntitySpeed = new Vector3d(entity.f_19854_ - prevPrevPosX, entity.f_19855_ - prevPrevPosY, entity.f_19856_ - prevPrevPosZ);
        if (!particle.entityCollisionTime.containsKey(entity)) {
            prevEntitySpeed.mul(0.0);
        } else {
            particle.offset.x = entitySpeed.x;
            particle.offset.z = entitySpeed.z;
            if (now == null) {
                particle.position.x += (double)entitySpeed.x;
                particle.position.z += (double)entitySpeed.z;
            } else {
                now.x += (double)entitySpeed.x;
                now.z += (double)entitySpeed.z;
            }
        }
        particle.speed.x = (float)((double)particle.speed.x + (double)java.lang.Math.round((prevEntitySpeed.x - (double)entitySpeed.x) * 1000.0) / 250.0);
        particle.speed.y = (float)((double)particle.speed.y + (double)java.lang.Math.round((prevEntitySpeed.y - (double)entitySpeed.y) * 1000.0) / 250.0);
        particle.speed.z = (float)((double)particle.speed.z + (double)java.lang.Math.round((prevEntitySpeed.z - (double)entitySpeed.z) * 1000.0) / 250.0);
    }

    public void momentum(BedrockParticle particle, Entity entity) {
        Vec3 ePos = entity.m_20182_();
        Vec3 dMove = ePos.m_82492_(entity.f_19854_, entity.f_19855_, entity.f_19856_);
        Vector3f entitySpeed = new Vector3f((float)dMove.f_82479_, (float)dMove.f_82480_, (float)dMove.f_82481_);
        particle.speed.x += 2.0f * entitySpeed.x;
        particle.speed.y += 2.0f * entitySpeed.y;
        particle.speed.z += 2.0f * entitySpeed.z;
    }

    public void drag(BedrockParticle particle) {
        if (this.randomBounciness == 0.0f && !this.realisticCollision || java.lang.Math.round(particle.speed.x * 10000.0f) != 0 || java.lang.Math.round(particle.speed.y * 10000.0f) != 0 || java.lang.Math.round(particle.speed.z * 10000.0f) != 0) {
            particle.dragFactor = this.collisionDrag;
        }
    }

    public Vector3f damping(Vector3f vector) {
        float random = (float)((double)this.randomDamp * (java.lang.Math.random() * 2.0 - 1.0));
        return vector.mul(Math.clamp(0.0f, 1.0f, 1.0f - this.damp + random));
    }

    public void splitParticle(BedrockParticle particle, ParticleEmitter emitter, EnumFacing.Axis component, Vector3d now, Vector3d prev) {
        float speed = ParcomMotionCollision.getComponent(particle.speed, component);
        if (!(java.lang.Math.abs(speed) > java.lang.Math.abs(this.splitParticleSpeedThreshold))) {
            return;
        }
        for (int i = 0; i < this.splitParticleCount; ++i) {
            BedrockParticle splitParticle = emitter.createParticle(false);
            particle.softCopy(splitParticle);
            splitParticle.position.set((Vector3dc)now);
            splitParticle.prevPosition.set((Vector3dc)prev);
            splitParticle.bounces = 1;
            double splitPosition = ParcomMotionCollision.getComponent(splitParticle.position, component);
            ParcomMotionCollision.setComponent(splitParticle.collisionTime, component, particle.age);
            ParcomMotionCollision.setComponent(splitParticle.position, component, splitPosition);
            Vector3f randomSpeed = this.randomBounciness(particle.speed, component, this.randomBounciness != 0.0f ? this.randomBounciness : 10.0f);
            randomSpeed.mul(1.0f / (float)this.splitParticleCount);
            splitParticle.speed.set((Vector3fc)randomSpeed);
            if (this.damp != 0.0f) {
                splitParticle.speed = this.damping(splitParticle.speed);
            }
            emitter.splitParticles.add(splitParticle);
        }
        particle.dead = true;
    }

    public Vector3f randomBounciness(Vector3f vector0, EnumFacing.Axis component, float randomness) {
        if (randomness != 0.0f) {
            Vector3f vector = new Vector3f((Vector3fc)vector0);
            float randomfactor = 0.25f;
            float prevLength = vector.length();
            float random1 = (float)java.lang.Math.random() * (randomness *= 0.1f);
            float random2 = (float)((double)(randomness * randomfactor) * (java.lang.Math.random() * 2.0 - 1.0));
            float random3 = (float)((double)(randomness * randomfactor) * (java.lang.Math.random() * 2.0 - 1.0));
            float vectorValue = ParcomMotionCollision.getComponent(vector, component);
            if (component == EnumFacing.Axis.X) {
                vector.y += random2;
                vector.z += random3;
            } else if (component == EnumFacing.Axis.Y) {
                vector.x += random2;
                vector.z += random3;
            } else {
                vector.y += random2;
                vector.x += random3;
            }
            if (this.bounciness != 0.0f) {
                ParcomMotionCollision.setComponent(vector, component, vectorValue + (vectorValue < 0.0f ? -random1 : random1));
                vector.mul(prevLength / vector.length());
            } else if (vector.x != 0.0f || vector.y != 0.0f || vector.z != 0.0f) {
                if (this.preserveEnergy) {
                    ParcomMotionCollision.setComponent(vector, component, 0.0f);
                }
                if (vector.x != 0.0f || vector.y != 0.0f || vector.z != 0.0f) {
                    vector.mul(prevLength / vector.length());
                }
                ParcomMotionCollision.setComponent(vector, component, vectorValue);
            } else {
                return vector0;
            }
            return vector;
        }
        return vector0;
    }

    public Vector3d intersect(Vector3f ray, Vector3d orig, AABB aabb) {
        double tzmax;
        double tzmin;
        double tymax;
        double tymin;
        double tmin = (aabb.f_82288_ - orig.x) / (double)ray.x;
        double tmax = (aabb.f_82291_ - orig.x) / (double)ray.x;
        if (tmin > tmax) {
            double tminTmp = tmin;
            tmin = tmax;
            tmax = tminTmp;
        }
        if ((tymin = (aabb.f_82289_ - orig.y) / (double)ray.y) > (tymax = (aabb.f_82292_ - orig.y) / (double)ray.y)) {
            double tyminTmp = tymin;
            tymin = tymax;
            tymax = tyminTmp;
        }
        if (tmin > tymax || tymin > tmax) {
            return null;
        }
        if (tymin > tmin) {
            tmin = tymin;
        }
        if (tymax < tmax) {
            tmax = tymax;
        }
        if ((tzmin = (aabb.f_82290_ - orig.z) / (double)ray.z) > (tzmax = (aabb.f_82293_ - orig.z) / (double)ray.z)) {
            double tzminTmp = tzmin;
            tzmin = tzmax;
            tzmax = tzminTmp;
        }
        if (tmin > tzmax || tzmin > tmax) {
            return null;
        }
        if (tzmax < tmax) {
            tmax = tzmax;
        }
        Vector3d ray1 = new Vector3d((Vector3fc)ray);
        ray1.mul(tmax);
        return ray1;
    }

    public CollisionOffset calculateOffsets(AABB aabb, List<AABB> list, double x, double y, double z) {
        for (AABB AABB2 : list) {
            y = ParcomMotionCollision.calculateYOffset(AABB2, aabb, y);
        }
        aabb = aabb.m_82386_(0.0, y, 0.0);
        for (AABB AABB1 : list) {
            x = ParcomMotionCollision.calculateXOffset(AABB1, aabb, x);
        }
        aabb = aabb.m_82386_(x, 0.0, 0.0);
        for (AABB AABB2 : list) {
            z = ParcomMotionCollision.calculateZOffset(AABB2, aabb, z);
        }
        aabb = aabb.m_82386_(0.0, 0.0, z);
        return new CollisionOffset(aabb, x, y, z);
    }

    @Override
    public int getSortingIndex() {
        return 50;
    }

    public static float getComponent(Vector3f vector, EnumFacing.Axis component) {
        if (component == EnumFacing.Axis.X) {
            return vector.x;
        }
        if (component == EnumFacing.Axis.Y) {
            return vector.y;
        }
        return vector.z;
    }

    public static void setComponent(Vector3f vector, EnumFacing.Axis component, float value) {
        if (component == EnumFacing.Axis.X) {
            vector.x = value;
        } else if (component == EnumFacing.Axis.Y) {
            vector.y = value;
        } else {
            vector.z = value;
        }
    }

    public static void negateComponent(Vector3f vector, EnumFacing.Axis component) {
        ParcomMotionCollision.setComponent(vector, component, -ParcomMotionCollision.getComponent(vector, component));
    }

    public static double getComponent(Vector3d vector, EnumFacing.Axis component) {
        if (component == EnumFacing.Axis.X) {
            return vector.x;
        }
        if (component == EnumFacing.Axis.Y) {
            return vector.y;
        }
        return vector.z;
    }

    public static void setComponent(Vector3d vector, EnumFacing.Axis component, double value) {
        if (component == EnumFacing.Axis.X) {
            vector.x = value;
        } else if (component == EnumFacing.Axis.Y) {
            vector.y = value;
        } else {
            vector.z = value;
        }
    }

    public static void negateComponent(Vector3d vector, EnumFacing.Axis component) {
        ParcomMotionCollision.setComponent(vector, component, -ParcomMotionCollision.getComponent(vector, component));
    }

    public static double calculateXOffset(AABB thiz, AABB other, double offsetX) {
        if (other.f_82292_ > thiz.f_82289_ && other.f_82289_ < thiz.f_82292_ && other.f_82293_ > thiz.f_82290_ && other.f_82290_ < thiz.f_82293_) {
            double d0;
            if (offsetX > 0.0 && other.f_82291_ <= thiz.f_82288_) {
                double d1 = thiz.f_82288_ - other.f_82291_;
                if (d1 < offsetX) {
                    offsetX = d1;
                }
            } else if (offsetX < 0.0 && other.f_82288_ >= thiz.f_82291_ && (d0 = thiz.f_82291_ - other.f_82288_) > offsetX) {
                offsetX = d0;
            }
            return offsetX;
        }
        return offsetX;
    }

    public static double calculateYOffset(AABB thiz, AABB other, double offsetY) {
        if (other.f_82291_ > thiz.f_82288_ && other.f_82288_ < thiz.f_82291_ && other.f_82293_ > thiz.f_82290_ && other.f_82290_ < thiz.f_82293_) {
            double d0;
            if (offsetY > 0.0 && other.f_82292_ <= thiz.f_82289_) {
                double d1 = thiz.f_82289_ - other.f_82292_;
                if (d1 < offsetY) {
                    offsetY = d1;
                }
            } else if (offsetY < 0.0 && other.f_82289_ >= thiz.f_82292_ && (d0 = thiz.f_82292_ - other.f_82289_) > offsetY) {
                offsetY = d0;
            }
            return offsetY;
        }
        return offsetY;
    }

    public static double calculateZOffset(AABB thiz, AABB other, double offsetZ) {
        if (other.f_82291_ > thiz.f_82288_ && other.f_82288_ < thiz.f_82291_ && other.f_82292_ > thiz.f_82289_ && other.f_82289_ < thiz.f_82292_) {
            double d0;
            if (offsetZ > 0.0 && other.f_82293_ <= thiz.f_82290_) {
                double d1 = thiz.f_82290_ - other.f_82293_;
                if (d1 < offsetZ) {
                    offsetZ = d1;
                }
            } else if (offsetZ < 0.0 && other.f_82290_ >= thiz.f_82293_ && (d0 = thiz.f_82293_ - other.f_82290_) > offsetZ) {
                offsetZ = d0;
            }
            return offsetZ;
        }
        return offsetZ;
    }

    public static class CollisionOffset {
        public AABB aabb;
        public double x;
        public double y;
        public double z;

        public CollisionOffset(AABB aabb, double x, double y, double z) {
            this.aabb = aabb;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

