/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.particles.components.expiration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.zeith.hammeranims.api.particles.components.itf.IParticleUpdate;
import org.zeith.hammeranims.api.particles.emitter.BedrockParticle;
import org.zeith.hammeranims.api.particles.emitter.ParticleEmitter;

public class ParcomKillPlane
implements IParticleUpdate {
    public float a;
    public float b;
    public float c;
    public float d;

    public ParcomKillPlane(JsonElement element) {
        if (!element.isJsonArray()) {
            return;
        }
        JsonArray array = element.getAsJsonArray();
        if (array.size() >= 4) {
            this.a = array.get(0).getAsFloat();
            this.b = array.get(1).getAsFloat();
            this.c = array.get(2).getAsFloat();
            this.d = array.get(3).getAsFloat();
        }
    }

    @Override
    public void update(ParticleEmitter emitter, BedrockParticle particle) {
        if (particle.dead) {
            return;
        }
        Vector3d prevLocal = new Vector3d((Vector3dc)particle.prevPosition);
        Vector3d local = new Vector3d((Vector3dc)particle.position);
        if (!particle.relativePosition) {
            local.sub((Vector3dc)emitter.lastGlobal);
            prevLocal.sub((Vector3dc)emitter.lastGlobal);
        }
        double prev = (double)this.a * prevLocal.x + (double)this.b * prevLocal.y + (double)this.c * prevLocal.z + (double)this.d;
        double now = (double)this.a * local.x + (double)this.b * local.y + (double)this.c * local.z + (double)this.d;
        if (prev > 0.0 && now < 0.0 || prev < 0.0 && now > 0.0) {
            particle.dead = true;
        }
    }

    @Override
    public int getSortingIndex() {
        return 100;
    }
}

