/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.particles.components.expiration;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3d;
import org.zeith.hammeranims.api.particles.components.IParticleComponent;
import org.zeith.hammeranims.api.particles.emitter.BedrockParticle;
import org.zeith.hammeranims.api.particles.emitter.ParticleEmitter;
import org.zeith.hammeranims.core.utils.InstanceHelpers;

public class ParcomExpireBlocks
implements IParticleComponent {
    public List<Block> blocks = new ArrayList<Block>();
    public List<TagKey<Block>> blockTags = new ArrayList<TagKey<Block>>();
    private BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    public ParcomExpireBlocks(JsonElement elem) {
        if (!elem.isJsonArray()) {
            return;
        }
        for (JsonElement value : elem.getAsJsonArray()) {
            String s = value.getAsString();
            if (s.startsWith("#")) {
                this.blockTags.add((TagKey<Block>)BlockTags.create((ResourceLocation)InstanceHelpers.tryParseLocation(s.substring(1))));
                continue;
            }
            ResourceLocation location = InstanceHelpers.tryParseLocation(s);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
            if (block == null) continue;
            this.blocks.add(block);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(BlockState state) {
        if (this.blocks.contains(state.m_60734_())) return true;
        if (!this.blockTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) return false;
        return true;
    }

    public BlockState getBlockState(ParticleEmitter emitter, BedrockParticle particle) {
        if (emitter.world == null) {
            return Blocks.f_50016_.m_49966_();
        }
        Vector3d position = particle.getGlobalPosition(emitter);
        this.pos.m_122169_(position.x(), position.y(), position.z());
        return emitter.world.m_8055_((BlockPos)this.pos);
    }
}

