/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.particles.components.appearance;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.api.particles.emitter.BedrockParticle;
import org.zeith.hammeranims.api.particles.variables.ParticleVariables;
import org.zeith.hammeranims.joml.Math;

public abstract class Tint {
    public static Solid parseColor(JsonElement element) {
        JsonArray array;
        InterpolatedDouble<ParticleVariables> r = InterpolatedDouble.one();
        InterpolatedDouble<ParticleVariables> g = InterpolatedDouble.one();
        InterpolatedDouble<ParticleVariables> b = InterpolatedDouble.one();
        InterpolatedDouble<ParticleVariables> a = InterpolatedDouble.one();
        if (element.isJsonPrimitive()) {
            String hex = element.getAsString();
            if (hex.startsWith("#") && (hex.length() == 7 || hex.length() == 9)) {
                boolean hasAlpha = hex.length() == 9;
                try {
                    int color = Integer.parseInt(hex.substring(hasAlpha ? 3 : 1), 16);
                    float hr = (float)(color >> 16 & 0xFF) / 255.0f;
                    float hg = (float)(color >> 8 & 0xFF) / 255.0f;
                    float hb = (float)(color & 0xFF) / 255.0f;
                    float ha = hasAlpha ? (float)Integer.parseInt(hex.substring(1, 3), 16) / 255.0f : 1.0f;
                    r = InterpolatedDouble.constant(hr);
                    g = InterpolatedDouble.constant(hg);
                    b = InterpolatedDouble.constant(hb);
                    a = InterpolatedDouble.constant(ha);
                }
                catch (Exception exception) {}
            }
        } else if (element.isJsonArray() && ((array = element.getAsJsonArray()).size() == 3 || array.size() == 4)) {
            r = InterpolatedDouble.parse(array.get(0));
            g = InterpolatedDouble.parse(array.get(1));
            b = InterpolatedDouble.parse(array.get(2));
            if (array.size() == 4) {
                a = InterpolatedDouble.parse(array.get(3));
            }
        }
        return new Solid(r, g, b, a);
    }

    public static Tint parseGradient(JsonObject color) {
        JsonElement gradient = color.get("gradient");
        InterpolatedDouble<ParticleVariables> expression = InterpolatedDouble.zero();
        ArrayList<Gradient.ColorStop> colorStops = new ArrayList<Gradient.ColorStop>();
        boolean equal = true;
        if (gradient.isJsonObject()) {
            for (Map.Entry entry : gradient.getAsJsonObject().entrySet()) {
                Solid stopColor = Tint.parseColor((JsonElement)entry.getValue());
                colorStops.add(new Gradient.ColorStop(Float.parseFloat((String)entry.getKey()), stopColor));
            }
            colorStops.sort((a, b) -> Float.compare(a.stop, b.stop));
            equal = false;
        } else if (gradient.isJsonArray()) {
            JsonArray colors = gradient.getAsJsonArray();
            int i = 0;
            for (JsonElement stop : colors) {
                colorStops.add(new Gradient.ColorStop((float)i / (float)(colors.size() - 1), Tint.parseColor(stop)));
                ++i;
            }
        }
        float range = ((Gradient.ColorStop)colorStops.get((int)(colorStops.size() - 1))).stop;
        for (Gradient.ColorStop stop : colorStops) {
            stop.stop /= range;
        }
        if (color.has("interpolant")) {
            expression = InterpolatedDouble.parse(color.get("interpolant"));
        }
        return new Gradient(colorStops, range, expression, equal);
    }

    public abstract void compute(ParticleVariables var1, BedrockParticle var2);

    public static class Solid
    extends Tint {
        public InterpolatedDouble<ParticleVariables> r;
        public InterpolatedDouble<ParticleVariables> g;
        public InterpolatedDouble<ParticleVariables> b;
        public InterpolatedDouble<ParticleVariables> a;

        public Solid(InterpolatedDouble<ParticleVariables> r, InterpolatedDouble<ParticleVariables> g, InterpolatedDouble<ParticleVariables> b, InterpolatedDouble<ParticleVariables> a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public Solid() {
            this.r = InterpolatedDouble.one();
            this.g = InterpolatedDouble.one();
            this.b = InterpolatedDouble.one();
            this.a = InterpolatedDouble.one();
        }

        @Override
        public void compute(ParticleVariables vars, BedrockParticle particle) {
            particle.r = (float)this.r.get(vars);
            particle.g = (float)this.g.get(vars);
            particle.b = (float)this.b.get(vars);
            particle.a = (float)this.a.get(vars);
        }

        public void lerp(BedrockParticle particle, float factor, ParticleVariables vars) {
            particle.r = Math.lerp(particle.r, (float)this.r.get(vars), factor);
            particle.g = Math.lerp(particle.g, (float)this.g.get(vars), factor);
            particle.b = Math.lerp(particle.b, (float)this.b.get(vars), factor);
            particle.a = Math.lerp(particle.a, (float)this.a.get(vars), factor);
        }
    }

    public static class Gradient
    extends Tint {
        public List<ColorStop> stops;
        public InterpolatedDouble<ParticleVariables> interpolant;
        public float range = 1.0f;
        public boolean equal;

        public Gradient(List<ColorStop> stops, float range, InterpolatedDouble<ParticleVariables> interpolant, boolean equal) {
            this.stops = stops;
            this.range = range;
            this.interpolant = interpolant;
            this.equal = equal;
        }

        public Gradient() {
            this.stops = new ArrayList<ColorStop>();
            this.stops.add(new ColorStop(0.0f, new Solid(InterpolatedDouble.constant(1.0), InterpolatedDouble.constant(1.0), InterpolatedDouble.constant(1.0), InterpolatedDouble.constant(1.0))));
            this.stops.add(new ColorStop(1.0f, new Solid(InterpolatedDouble.constant(0.0), InterpolatedDouble.constant(0.0), InterpolatedDouble.constant(0.0), InterpolatedDouble.constant(1.0))));
            this.interpolant = InterpolatedDouble.zero();
            this.equal = false;
        }

        public void sort() {
            this.stops.sort((a, b) -> Float.compare(a.stop, b.stop));
        }

        @Override
        public void compute(ParticleVariables vars, BedrockParticle particle) {
            ColorStop prev;
            int length = this.stops.size();
            if (length == 0) {
                particle.a = 1.0f;
                particle.b = 1.0f;
                particle.g = 1.0f;
                particle.r = 1.0f;
                return;
            }
            if (length == 1) {
                this.stops.get((int)0).color.compute(vars, particle);
                return;
            }
            double factor = this.interpolant.get(vars);
            if ((factor = Math.clamp(0.0, 1.0, factor)) < (double)(prev = this.stops.get(0)).getStop(this.range)) {
                prev.color.compute(vars, particle);
                return;
            }
            for (int i = 1; i < length; ++i) {
                ColorStop stop = this.stops.get(i);
                if ((double)stop.getStop(this.range) > factor) {
                    prev.color.compute(vars, particle);
                    stop.color.lerp(particle, (float)(factor - (double)prev.getStop(this.range)) / (stop.getStop(this.range) - prev.getStop(this.range)), vars);
                    return;
                }
                prev = stop;
            }
            prev.color.compute(vars, particle);
        }

        public static class ColorStop {
            public float stop;
            public Solid color;

            public ColorStop(float stop, Solid color) {
                this.stop = stop;
                this.color = color;
            }

            public float getStop(float range) {
                return this.stop * range;
            }
        }
    }
}

