/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.particles.components.appearance;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.api.particles.ParticleMaterial;
import org.zeith.hammeranims.api.particles.variables.ParticleVariables;
import org.zeith.hammeranims.core.contents.particles.components.appearance.ParcomAppearanceBillboard;
import org.zeith.hammeranims.core.utils.InstanceHelpers;

public class ParcomCollisionAppearance
extends ParcomAppearanceBillboard {
    public ParticleMaterial material = ParticleMaterial.OPAQUE;
    public ResourceLocation texture = InventoryMenu.f_39692_;
    public InterpolatedDouble<ParticleVariables> enabled = InterpolatedDouble.constant(0.0);
    public boolean lit;

    public ParcomCollisionAppearance(JsonElement elem) {
        super(elem);
        if (!elem.isJsonObject()) {
            return;
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("enabled")) {
            this.enabled = InterpolatedDouble.parse(element.get("enabled"));
        }
        if (element.has("lit")) {
            this.lit = element.get("lit").getAsBoolean();
        }
        if (element.has("material")) {
            this.material = ParticleMaterial.fromString(element.get("material").getAsString());
        }
        if (element.has("texture")) {
            String texture = element.get("texture").getAsString();
            this.texture = InstanceHelpers.tryParseLocation(texture);
        }
    }
}

