/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.particles.components.appearance;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.CameraType;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.zeith.hammeranims.api.animation.interp.InterpolatedDouble;
import org.zeith.hammeranims.api.particles.components.itf.IParticleRender;
import org.zeith.hammeranims.api.particles.emitter.BedrockParticle;
import org.zeith.hammeranims.api.particles.emitter.ParticleEmitter;
import org.zeith.hammeranims.api.particles.variables.ParticleVariables;
import org.zeith.hammeranims.core.contents.particles.components.appearance.CameraFacing;

public class ParcomAppearanceBillboard
implements IParticleRender {
    public InterpolatedDouble<ParticleVariables> sizeW = InterpolatedDouble.zero();
    public InterpolatedDouble<ParticleVariables> sizeH = InterpolatedDouble.zero();
    public CameraFacing facing = CameraFacing.LOOKAT_XYZ;
    public boolean customDirection = false;
    public float directionSpeedThreshhold = 0.01f;
    public InterpolatedDouble<ParticleVariables> directionX = InterpolatedDouble.zero();
    public InterpolatedDouble<ParticleVariables> directionY = InterpolatedDouble.zero();
    public InterpolatedDouble<ParticleVariables> directionZ = InterpolatedDouble.zero();
    public int textureWidth = 128;
    public int textureHeight = 128;
    public InterpolatedDouble<ParticleVariables> uvX = InterpolatedDouble.zero();
    public InterpolatedDouble<ParticleVariables> uvY = InterpolatedDouble.zero();
    public InterpolatedDouble<ParticleVariables> uvW = InterpolatedDouble.zero();
    public InterpolatedDouble<ParticleVariables> uvH = InterpolatedDouble.zero();
    public boolean flipbook = false;
    public float stepX;
    public float stepY;
    public float fps;
    public InterpolatedDouble<ParticleVariables> maxFrame = InterpolatedDouble.zero();
    public boolean stretchFPS = false;
    public boolean loop = false;
    protected float w;
    protected float h;
    protected float u1;
    protected float v1;
    protected float u2;
    protected float v2;
    protected Matrix4f transform = new Matrix4f();
    protected Matrix4f rotation = new Matrix4f();
    protected Vector4f[] vertices = new Vector4f[]{new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f)};
    protected Vector3f vector = new Vector3f();
    protected Vector3f direction = new Vector3f();

    public ParcomAppearanceBillboard(JsonElement elem) {
        JsonArray size;
        if (!elem.isJsonObject()) {
            return;
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("size") && element.get("size").isJsonArray() && (size = element.getAsJsonArray("size")).size() >= 2) {
            this.sizeW = InterpolatedDouble.parse(size.get(0));
            this.sizeH = InterpolatedDouble.parse(size.get(1));
        }
        if (element.has("facing_camera_mode")) {
            this.facing = CameraFacing.fromString(element.get("facing_camera_mode").getAsString());
        }
        if (this.facing.isDirection && element.has("direction")) {
            this.parseDirection(element.get("direction").getAsJsonObject());
        }
        if (element.has("uv") && element.get("uv").isJsonObject()) {
            this.parseUv(element.get("uv").getAsJsonObject());
        }
    }

    protected void parseDirection(JsonObject object) {
        boolean bl = this.customDirection = object.has("mode") && object.get("mode").getAsString().equals("custom");
        if (this.customDirection && object.has("custom_direction")) {
            JsonArray directionArray = object.getAsJsonArray("custom_direction");
            this.directionX = InterpolatedDouble.parse(directionArray.get(0));
            this.directionY = InterpolatedDouble.parse(directionArray.get(1));
            this.directionZ = InterpolatedDouble.parse(directionArray.get(2));
        } else if (!this.customDirection && object.has("min_speed_threshold")) {
            this.directionSpeedThreshhold = object.get("min_speed_threshold").getAsFloat();
        }
    }

    protected void parseUv(JsonObject object) {
        JsonArray uv;
        if (object.has("texture_width")) {
            this.textureWidth = object.get("texture_width").getAsInt();
        }
        if (object.has("texture_height")) {
            this.textureHeight = object.get("texture_height").getAsInt();
        }
        if (object.has("uv") && object.get("uv").isJsonArray() && (uv = object.getAsJsonArray("uv")).size() >= 2) {
            this.uvX = InterpolatedDouble.parse(uv.get(0));
            this.uvY = InterpolatedDouble.parse(uv.get(1));
        }
        if (object.has("uv_size") && object.get("uv_size").isJsonArray() && (uv = object.getAsJsonArray("uv_size")).size() >= 2) {
            this.uvW = InterpolatedDouble.parse(uv.get(0));
            this.uvH = InterpolatedDouble.parse(uv.get(1));
        }
        if (object.has("flipbook") && object.get("flipbook").isJsonObject()) {
            this.flipbook = true;
            this.parseFlipbook(object.get("flipbook").getAsJsonObject());
        }
    }

    protected void parseFlipbook(JsonObject flipbook) {
        JsonArray uv;
        if (flipbook.has("base_UV") && flipbook.get("base_UV").isJsonArray() && (uv = flipbook.getAsJsonArray("base_UV")).size() >= 2) {
            this.uvX = InterpolatedDouble.parse(uv.get(0));
            this.uvY = InterpolatedDouble.parse(uv.get(1));
        }
        if (flipbook.has("size_UV") && flipbook.get("size_UV").isJsonArray() && (uv = flipbook.getAsJsonArray("size_UV")).size() >= 2) {
            this.uvW = InterpolatedDouble.parse(uv.get(0));
            this.uvH = InterpolatedDouble.parse(uv.get(1));
        }
        if (flipbook.has("step_UV") && flipbook.get("step_UV").isJsonArray() && (uv = flipbook.getAsJsonArray("step_UV")).size() >= 2) {
            this.stepX = uv.get(0).getAsFloat();
            this.stepY = uv.get(1).getAsFloat();
        }
        if (flipbook.has("frames_per_second")) {
            this.fps = flipbook.get("frames_per_second").getAsFloat();
        }
        if (flipbook.has("max_frame")) {
            this.maxFrame = InterpolatedDouble.parse(flipbook.get("max_frame"));
        }
        if (flipbook.has("stretch_to_lifetime")) {
            this.stretchFPS = flipbook.get("stretch_to_lifetime").getAsBoolean();
        }
        if (flipbook.has("loop")) {
            this.loop = flipbook.get("loop").getAsBoolean();
        }
    }

    @Override
    public boolean supportsCollissionRendering() {
        return this.getClass() == ParcomAppearanceBillboard.class;
    }

    @Override
    public void render(ParticleVariables vars, ParticleEmitter emitter, BedrockParticle particle, VertexConsumer builder, PoseStack pose, float partialTicks) {
        this.calculateUVs(vars, particle, partialTicks);
        double px = Math.lerp((double)particle.prevPosition.x, (double)particle.position.x, (double)partialTicks);
        double py = Math.lerp((double)particle.prevPosition.y, (double)particle.position.y, (double)partialTicks);
        double pz = Math.lerp((double)particle.prevPosition.z, (double)particle.position.z, (double)partialTicks);
        float angle = Math.lerp((float)particle.prevRotation, (float)particle.rotation, (float)partialTicks);
        Vector3d pos = this.calculatePosition(emitter, particle, px, py, pz);
        px = pos.x;
        py = pos.y;
        pz = pos.z;
        int light = emitter.getBrightnessForRender(partialTicks, px, py, pz);
        this.calculateFacing(vars, emitter, particle, px, py, pz);
        this.rotation.identity().rotateZ(angle / 180.0f * (float)java.lang.Math.PI);
        this.transform.mul((Matrix4fc)this.rotation);
        this.transform.setTranslation((Vector3fc)new Vector3f((float)px, (float)py, (float)pz));
        for (Vector4f vt : this.vertices) {
            this.transform.transform(vt);
        }
        Vector3f norm = this.transform.transformPosition(new Vector3f(0.0f, 1.0f, 0.0f)).normalize();
        float u1 = this.u1 / (float)this.textureWidth;
        float u2 = this.u2 / (float)this.textureWidth;
        float v1 = this.v1 / (float)this.textureHeight;
        float v2 = this.v2 / (float)this.textureHeight;
        Matrix4f lp = pose.m_85850_().m_252922_();
        builder.m_252986_(lp, this.vertices[0].x, this.vertices[0].y, this.vertices[0].z).m_7421_(u1, v1).m_85950_(particle.r, particle.g, particle.b, particle.a).m_85969_(light).m_5752_();
        builder.m_252986_(lp, this.vertices[1].x, this.vertices[1].y, this.vertices[1].z).m_7421_(u2, v1).m_85950_(particle.r, particle.g, particle.b, particle.a).m_85969_(light).m_5752_();
        builder.m_252986_(lp, this.vertices[2].x, this.vertices[2].y, this.vertices[2].z).m_7421_(u2, v2).m_85950_(particle.r, particle.g, particle.b, particle.a).m_85969_(light).m_5752_();
        builder.m_252986_(lp, this.vertices[3].x, this.vertices[3].y, this.vertices[3].z).m_7421_(u1, v2).m_85950_(particle.r, particle.g, particle.b, particle.a).m_85969_(light).m_5752_();
    }

    protected void calculateFacing(ParticleVariables vars, ParticleEmitter emitter, BedrockParticle particle, double px, double py, double pz) {
        this.rotation.identity();
        this.transform.identity();
        float cameraYaw = emitter.cYaw;
        float cameraPitch = emitter.cPitch;
        double cameraX = emitter.cX;
        double cameraY = emitter.cY;
        double cameraZ = emitter.cZ;
        if (emitter.perspective == CameraType.THIRD_PERSON_FRONT) {
            this.w = -this.w;
        } else if (emitter.perspective == null && !this.facing.isLookAt) {
            cameraYaw = 180.0f - cameraYaw;
            this.w = -this.w;
            this.h = -this.h;
        }
        if (this.facing.isLookAt && !this.facing.isDirection) {
            double dX = cameraX - px;
            double dY = cameraY - py;
            double dZ = cameraZ - pz;
            double horizontalDistance = Math.sqrt((double)(dX * dX + dZ * dZ));
            cameraYaw = 180.0f - (float)(Math.atan2((double)dZ, (double)dX) * 57.29577951308232) - 90.0f;
            cameraPitch = (float)(-(Math.atan2((double)dY, (double)horizontalDistance) * 57.29577951308232)) + 180.0f;
        }
        if (this.facing.isDirection) {
            if (this.customDirection) {
                this.direction.x = (float)this.directionX.get(vars);
                this.direction.y = (float)this.directionY.get(vars);
                this.direction.z = (float)this.directionZ.get(vars);
            } else if (particle.speed.lengthSquared() > this.directionSpeedThreshhold * this.directionSpeedThreshhold) {
                this.direction.set((Vector3fc)particle.speed);
                this.direction.normalize();
            } else {
                this.direction.set(1.0f, 0.0f, 0.0f);
            }
            double lengthSq = this.direction.lengthSquared();
            if (lengthSq < 1.0E-4) {
                this.direction.set(1.0f, 0.0f, 0.0f);
            } else if (Math.abs((double)(lengthSq - 1.0)) > 1.0E-4) {
                this.direction.normalize();
            }
        }
        this.calculateVertices(emitter, particle);
        switch (this.facing) {
            case ROTATE_XYZ: 
            case LOOKAT_XYZ: {
                this.rotation.identity().rotateY(Math.toRadians((float)cameraYaw));
                this.transform.mul((Matrix4fc)this.rotation);
                this.rotation.identity().rotateX(Math.toRadians((float)cameraPitch));
                this.transform.mul((Matrix4fc)this.rotation);
                return;
            }
            case ROTATE_Y: 
            case LOOKAT_Y: {
                this.rotation.identity().rotateY(Math.toRadians((float)cameraYaw));
                this.transform.mul((Matrix4fc)this.rotation);
                return;
            }
            case EMITTER_YZ: {
                if (!emitter.isRenderingGUI) {
                    this.rotation.identity().rotateZ(Math.toRadians((float)180.0f));
                    this.transform.mul((Matrix4fc)this.rotation);
                    this.rotation.identity().rotateY(Math.toRadians((float)90.0f));
                    this.transform.mul((Matrix4fc)this.rotation);
                } else {
                    this.rotation.identity().rotateY(Math.toRadians((float)-90.0f));
                    this.transform.mul((Matrix4fc)this.rotation);
                }
                return;
            }
            case EMITTER_XZ: {
                if (!emitter.isRenderingGUI) {
                    this.rotation.identity().rotateX(Math.toRadians((float)90.0f));
                    this.transform.mul((Matrix4fc)this.rotation);
                } else {
                    this.rotation.identity().rotateZ(Math.toRadians((float)180.0f));
                    this.transform.mul((Matrix4fc)this.rotation);
                    this.rotation.identity().rotateX(Math.toRadians((float)-90.0f));
                    this.transform.mul((Matrix4fc)this.rotation);
                }
                return;
            }
            case EMITTER_XY: {
                if (!emitter.isRenderingGUI) {
                    this.rotation.identity().rotateX(Math.toRadians((float)180.0f));
                    this.transform.mul((Matrix4fc)this.rotation);
                } else {
                    this.rotation.identity().rotateY(Math.toRadians((float)180.0f));
                    this.transform.mul((Matrix4fc)this.rotation);
                }
                return;
            }
            case DIRECTION_X: {
                this.rotation.identity().rotateY(Math.toRadians((float)this.getYaw()));
                this.transform.mul((Matrix4fc)this.rotation);
                this.rotation.identity().rotateX(Math.toRadians((float)this.getPitch()));
                this.transform.mul((Matrix4fc)this.rotation);
                this.rotation.identity().rotateY(Math.toRadians((float)90.0f));
                this.transform.mul((Matrix4fc)this.rotation);
                return;
            }
            case DIRECTION_Y: {
                this.rotation.identity().rotateY(Math.toRadians((float)this.getYaw()));
                this.transform.mul((Matrix4fc)this.rotation);
                this.rotation.identity().rotateX(Math.toRadians((float)(this.getPitch() + 90.0f)));
                this.transform.mul((Matrix4fc)this.rotation);
                return;
            }
            case DIRECTION_Z: {
                this.rotation.identity().rotateY(Math.toRadians((float)this.getYaw()));
                this.transform.mul((Matrix4fc)this.rotation);
                this.rotation.identity().rotateX(Math.toRadians((float)this.getPitch()));
                this.transform.mul((Matrix4fc)this.rotation);
                return;
            }
            case LOOKAT_DIRECTION: {
                this.rotation.identity();
                this.rotation.identity().rotateY(Math.toRadians((float)this.getYaw()));
                this.transform.mul((Matrix4fc)this.rotation);
                this.rotation.identity().rotateX(Math.toRadians((float)(this.getPitch() + 90.0f)));
                this.transform.mul((Matrix4fc)this.rotation);
                Vector3f cameraDir = new Vector3f((float)(cameraX - px), (float)(cameraY - py), (float)(cameraZ - pz));
                Vector3f rotatedNormal = new Vector3f(0.0f, 0.0f, 1.0f);
                this.transform.transformPosition(rotatedNormal);
                Vector3f projectDir = new Vector3f((Vector3fc)this.direction);
                projectDir.mul(cameraDir.dot((Vector3fc)this.direction));
                cameraDir.sub((Vector3fc)projectDir);
                if ((double)cameraDir.lengthSquared() < 1.0E-30) {
                    return;
                }
                cameraDir.normalize();
                Vector3f rotationDirection = new Vector3f();
                rotationDirection.cross((Vector3fc)cameraDir, rotatedNormal);
                this.rotation.identity().rotateY(-java.lang.Math.copySign(cameraDir.angle((Vector3fc)rotatedNormal), rotationDirection.dot((Vector3fc)this.direction)));
                this.transform.mul((Matrix4fc)this.rotation);
                return;
            }
        }
    }

    private float getYaw() {
        double yaw = Math.atan2((float)(-this.direction.x), (float)this.direction.z);
        if ((yaw = Math.toDegrees((double)yaw)) < -180.0) {
            yaw += 360.0;
        } else if (yaw > 180.0) {
            yaw -= 360.0;
        }
        return (float)(-yaw);
    }

    private float getPitch() {
        double pitch = Math.atan2((float)this.direction.y, (float)Math.sqrt((float)(this.direction.x * this.direction.x + this.direction.z * this.direction.z)));
        return (float)(-Math.toDegrees((double)pitch));
    }

    protected void calculateVertices(ParticleEmitter emitter, BedrockParticle particle) {
        this.transform.identity();
        float hw = this.w * 0.5f;
        float hh = this.h * 0.5f;
        if (particle.relativeScaleBillboard) {
            hw = (float)((double)hw * emitter.scale[0]);
            hh = (float)((double)hh * emitter.scale[1]);
        }
        this.vertices[0].set(-hw, -hh, 0.0f, 1.0f);
        this.vertices[1].set(hw, -hh, 0.0f, 1.0f);
        this.vertices[2].set(hw, hh, 0.0f, 1.0f);
        this.vertices[3].set(-hw, hh, 0.0f, 1.0f);
    }

    protected Vector3d calculatePosition(ParticleEmitter emitter, BedrockParticle particle, double px, double py, double pz) {
        if (particle.relativePosition && particle.relativeRotation) {
            this.vector.set((float)px, (float)py, (float)pz);
            if (particle.relativeScale) {
                Vector3d pos = new Vector3d(px, py, pz);
                Matrix3d scale = new Matrix3d(emitter.scale[0], 0.0, 0.0, 0.0, emitter.scale[1], 0.0, 0.0, 0.0, emitter.scale[2]);
                scale.transform(pos);
                this.vector.x = (float)pos.x;
                this.vector.y = (float)pos.y;
                this.vector.z = (float)pos.z;
            }
            emitter.rotation.transform(this.vector);
            px = this.vector.x;
            py = this.vector.y;
            pz = this.vector.z;
            px += emitter.lastGlobal.x;
            py += emitter.lastGlobal.y;
            pz += emitter.lastGlobal.z;
        } else if (particle.relativeScale) {
            Vector3d pos = new Vector3d(px, py, pz);
            Matrix3d scale = new Matrix3d(emitter.scale[0], 0.0, 0.0, 0.0, emitter.scale[1], 0.0, 0.0, 0.0, emitter.scale[2]);
            pos.sub((Vector3dc)emitter.lastGlobal);
            scale.transform(pos);
            pos.add((Vector3dc)emitter.lastGlobal);
            px = pos.x;
            py = pos.y;
            pz = pos.z;
        }
        return new Vector3d(px, py, pz);
    }

    @Override
    public void renderOnScreen(ParticleVariables vars, BedrockParticle particle, VertexConsumer builder, PoseStack pose, int x, int y, float scale, float partialTicks) {
        this.calculateUVs(vars, particle, partialTicks);
        this.h = 0.5f;
        this.w = 0.5f;
        float angle = Math.lerp((float)particle.prevRotation, (float)particle.rotation, (float)partialTicks);
        float hw = this.w * 0.5f;
        float hh = this.h * 0.5f;
        this.vertices[0].set(-hw, -hh, 0.0f, 1.0f);
        this.vertices[1].set(hw, -hh, 0.0f, 1.0f);
        this.vertices[2].set(hw, hh, 0.0f, 1.0f);
        this.vertices[3].set(-hw, hh, 0.0f, 1.0f);
        this.transform.identity();
        this.transform.scale(scale * 2.75f);
        this.transform.setTranslation((Vector3fc)new Vector3f((float)x, (float)y - scale / 2.0f, 0.0f));
        this.rotation.identity().rotateZ(angle / 180.0f * (float)java.lang.Math.PI);
        this.transform.mul((Matrix4fc)this.rotation);
        for (Vector4f vertex : this.vertices) {
            this.transform.transform(vertex);
        }
        float u1 = this.u1 / (float)this.textureWidth;
        float u2 = this.u2 / (float)this.textureWidth;
        float v1 = this.v1 / (float)this.textureHeight;
        float v2 = this.v2 / (float)this.textureHeight;
        Matrix4f lp = pose.m_85850_().m_252922_();
        builder.m_252986_(lp, this.vertices[0].x, this.vertices[0].y, this.vertices[0].z).m_7421_(u1, v1).m_85950_(particle.r, particle.g, particle.b, particle.a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(lp, this.vertices[1].x, this.vertices[1].y, this.vertices[1].z).m_7421_(u2, v1).m_85950_(particle.r, particle.g, particle.b, particle.a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(lp, this.vertices[2].x, this.vertices[2].y, this.vertices[2].z).m_7421_(u2, v2).m_85950_(particle.r, particle.g, particle.b, particle.a).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(lp, this.vertices[3].x, this.vertices[3].y, this.vertices[3].z).m_7421_(u1, v2).m_85950_(particle.r, particle.g, particle.b, particle.a).m_85969_(0xF000F0).m_5752_();
    }

    public void calculateUVs(ParticleVariables vars, BedrockParticle particle, float partialTicks) {
        this.w = (float)this.sizeW.get(vars) * 2.25f;
        this.h = (float)this.sizeH.get(vars) * 2.25f;
        float u = (float)this.uvX.get(vars);
        float v = (float)this.uvY.get(vars);
        float w = (float)this.uvW.get(vars);
        float h = (float)this.uvH.get(vars);
        if (this.flipbook) {
            int index = (int)(particle.getAge(partialTicks) * (double)this.fps);
            int max = (int)this.maxFrame.get(vars);
            if (this.stretchFPS) {
                float lifetime;
                float f = lifetime = particle.lifetime <= 0 ? 0.0f : ((float)particle.age + partialTicks) / (float)particle.lifetime;
                if (particle.getExpireAge() != -1) {
                    lifetime = particle.lifetime <= 0 ? 0.0f : ((float)particle.age + partialTicks) / (float)particle.getExpirationDelay();
                }
                index = (int)(lifetime * (float)max);
            }
            if (this.loop && max != 0) {
                index %= max;
            }
            if (index > max) {
                index = max;
            }
            u += this.stepX * (float)index;
            v += this.stepY * (float)index;
        }
        this.u1 = u;
        this.v1 = v;
        this.u2 = u + w;
        this.v2 = v + h;
    }
}

