/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.zeith.hammeranims.api.animsys.AnimationSystem;
import org.zeith.hammeranims.api.animsys.layer.AnimationLayer;
import org.zeith.hammeranims.api.geometry.IGeometryContainer;
import org.zeith.hammeranims.api.tile.IAnimatedEntity;
import org.zeith.hammeranims.core.init.ContainersHA;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityBilly
extends PathfinderMob
implements IAnimatedEntity {
    protected final AnimationSystem animations = AnimationSystem.create(this);

    public EntityBilly(EntityType<? extends EntityBilly> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        boolean posChanged;
        this.animations.tick();
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_20340_(false);
        this.m_6593_((Component)ContainersHA.BILLY_BLOCK.m_49954_());
        this.animations.startAnimationAt("ambient", ContainersHA.BILLY_BREATHE);
        Vec3 pos = this.m_20182_();
        double moved = Math.sqrt(pos.m_82531_(this.f_19854_, this.f_19855_, this.f_19856_));
        boolean bl = posChanged = Math.abs(pos.f_82479_ - this.f_19854_) >= 0.00390625 || Math.abs(pos.f_82481_ - this.f_19856_) >= 0.00390625;
        if (!posChanged) {
            moved = 0.0;
        }
        if (moved > 0.0) {
            this.animations.startAnimationAt("legs", ContainersHA.BILLY_WALK);
        } else {
            this.animations.stopAnimation("legs", 0.4f);
        }
    }

    @Override
    public void setupSystem(AnimationSystem.Builder builder) {
        builder.autoSync().addLayers(new AnimationLayer.Builder("ambient"), new AnimationLayer.Builder("legs"));
    }

    @Override
    public IGeometryContainer getObjectModel() {
        return ContainersHA.BILLY_GEOM;
    }

    @Override
    public AnimationSystem getAnimationSystem() {
        return this.animations;
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128365_("Animations", (Tag)this.animations.serializeNBT());
        super.m_7380_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        this.animations.deserializeNBT(pCompound.m_128469_("Animations"));
        super.m_7378_(pCompound);
    }

    @SubscribeEvent
    public static void attributes(EntityAttributeCreationEvent e) {
        e.put(ContainersHA.BILLY_ENTITY, Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22265_());
    }
}

