/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.core.utils.InstanceHelpers;
import org.zeith.hammeranims.net.PacketPlayParticleEffectAtPos;
import org.zeith.hammeranims.net.PacketProvideCustomParticleEffectList;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;

public class CommandParticle {
    public static final Map<UUID, CompletableFuture<Set<ResourceLocation>>> PLAYER_CUSTOM_MAP = new ConcurrentHashMap<UUID, CompletableFuture<Set<ResourceLocation>>>();

    public static CompletableFuture<Set<ResourceLocation>> getOrRequest(ServerPlayer player) {
        return PLAYER_CUSTOM_MAP.computeIfAbsent(player.m_36316_().getId(), uid -> {
            Network.sendTo((IPacket)new PacketProvideCustomParticleEffectList(), (ServerPlayer)player);
            return new CompletableFuture();
        });
    }

    public static CompletableFuture<Set<ResourceLocation>> getOrUnresolved(ServerPlayer player) {
        if (player == null) {
            return null;
        }
        return PLAYER_CUSTOM_MAP.computeIfAbsent(player.m_36316_().getId(), uid -> new CompletableFuture());
    }

    public static SuggestionProvider<CommandSourceStack> effectSuggestor() {
        return (cs, b) -> {
            HammerAnimationsApi.particleContainers().getKeys().stream().map(Objects::toString).forEach(arg_0 -> ((SuggestionsBuilder)b).suggest(arg_0));
            return CommandParticle.getOrRequest(((CommandSourceStack)cs.getSource()).m_81375_()).thenApply(custom -> {
                custom.stream().map(Objects::toString).forEach(arg_0 -> ((SuggestionsBuilder)b).suggest(arg_0));
                return b.build();
            });
        };
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"particle").then(Commands.m_82127_((String)"spawn").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"effect", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CommandParticle.effectSuggestor()).executes(cs -> {
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)cs, (String)"effect");
            Vec3 mcpos = ((CommandSourceStack)cs.getSource()).m_81371_();
            Vector3d pos = new Vector3d(mcpos.f_82479_, mcpos.f_82480_, mcpos.f_82481_);
            LevelChunk chunk = ((CommandSourceStack)cs.getSource()).m_81372_().m_46745_(BlockPos.m_274446_((Position)mcpos));
            Network.sendToTracking((IPacket)new PacketPlayParticleEffectAtPos(pos, id), (LevelChunk)chunk);
            return 1;
        })).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120847_((boolean)true)).executes(cs -> {
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)cs, (String)"effect");
            Vec3 mcpos = Vec3Argument.m_120844_((CommandContext)cs, (String)"pos");
            Vector3d pos = new Vector3d(mcpos.f_82479_, mcpos.f_82480_, mcpos.f_82481_);
            LevelChunk chunk = ((CommandSourceStack)cs.getSource()).m_81372_().m_46745_(BlockPos.m_274446_((Position)mcpos));
            Network.sendToTracking((IPacket)new PacketPlayParticleEffectAtPos(pos, id), (LevelChunk)chunk);
            return 1;
        }))))).then(Commands.m_82127_((String)"hasplayer").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"effect", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CommandParticle.effectSuggestor()).executes(cs -> {
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)cs, (String)"effect");
            Collection players = EntityArgument.m_91477_((CommandContext)cs, (String)"players");
            int has = (int)players.stream().map(CommandParticle::getOrRequest).filter(CompletableFuture::isDone).map(CompletableFuture::join).filter(s -> s.contains(id)).count();
            if (has > 0) {
                ((CommandSourceStack)cs.getSource()).m_288197_(() -> InstanceHelpers.componentTranslate("command.hammeranims:has_particle_effect", has, id), true);
            } else {
                ((CommandSourceStack)cs.getSource()).m_81352_(InstanceHelpers.componentTranslate("command.hammeranims:has_particle_effect", has, id));
            }
            return has;
        }))));
    }
}

