/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.zeith.hammeranims.api.animation.LoopMode;
import org.zeith.hammeranims.api.animsys.AnimationSystem;
import org.zeith.hammeranims.api.animsys.layer.AnimationLayer;
import org.zeith.hammeranims.api.geometry.IGeometryContainer;
import org.zeith.hammeranims.api.geometry.model.IPositionalModel;
import org.zeith.hammeranims.api.tile.IAnimatedTile;
import org.zeith.hammeranims.core.init.ContainersHA;
import org.zeith.hammeranims.core.init.DefaultsHA;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.tiles.TileSyncableTickable;

public class TileBilly
extends TileSyncableTickable
implements IAnimatedTile {
    @NBTSerializable
    public final AnimationSystem animations = AnimationSystem.create(this);
    protected final Matrix4f mat = new Matrix4f();

    public TileBilly(BlockEntityType<TileBilly> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void setupSystem(AnimationSystem.Builder builder) {
        builder.addLayers(AnimationLayer.builder("legs").mask(ContainersHA.BILLY_GEOM.getPositionalModel().maskAnyOfOrChildren("body"))).addLayers(AnimationLayer.builder("ambient"));
    }

    public void update() {
        super.update();
        this.animations.tick();
        int power = this.f_58857_.m_277086_(this.f_58858_);
        if (power > 0) {
            this.animations.startAnimationAt("legs", ContainersHA.BILLY_WALK.configure().speed((float)power / 15.0f).loopMode(LoopMode.ONCE).next(ContainersHA.BILLY_WALK.configure().speed(2.0f).loopMode(LoopMode.ONCE).next(DefaultsHA.NULL_ANIM.configure()).onFinish(ContainersHA.HELLO_WORLD_ACTION.defaultInstance().withMessage("YOLO"))));
        }
        this.animations.startAnimationAt("ambient", ContainersHA.BILLY_BREATHE.configure().speed(0.5f));
        this.mat.identity().translate((float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_(), (float)this.f_58858_.m_123343_() + 0.5f).rotateY(0.0f);
        IPositionalModel posMod = ContainersHA.BILLY_GEOM.getPositionalModel();
        posMod.applySystem(1.0f, this.animations);
        if (posMod.applyBoneTransforms(this.mat, "bob")) {
            Vector3f relativePos = new Vector3f(-0.125f, 0.125f, 0.0625f);
            this.mat.transformPosition(relativePos);
            Vector3f relativePosUp = new Vector3f(-0.125f, 0.125f, 0.125f);
            this.mat.transformPosition(relativePosUp);
            relativePosUp.sub((Vector3fc)relativePos).normalize(0.1f);
            if (this.atTickRate(5)) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)relativePos.x, (double)relativePos.y, (double)relativePos.z, (double)relativePosUp.x, (double)relativePosUp.y, (double)relativePosUp.z);
            }
        }
    }

    @Override
    public IGeometryContainer getObjectModel() {
        return ContainersHA.BILLY_GEOM;
    }

    @Override
    public AnimationSystem getAnimationSystem() {
        return this.animations;
    }
}

