/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.contents.actions;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammeranims.api.animsys.actions.AnimationAction;
import org.zeith.hammeranims.api.animsys.actions.AnimationActionInstance;
import org.zeith.hammeranims.api.animsys.layer.AnimationLayer;
import org.zeith.hammeranims.core.utils.InstanceHelpers;
import org.zeith.hammerlib.util.java.Cast;

public class PrintHelloWorldAction
extends AnimationAction {
    @Override
    public HelloWorldActionInstance defaultInstance() {
        return this.createInstance();
    }

    @Override
    @NotNull
    protected HelloWorldActionInstance createInstance() {
        return new HelloWorldActionInstance(this);
    }

    @Override
    public void execute(AnimationActionInstance instance, AnimationLayer layer) {
        Level world = this.getAnimationWorld(layer);
        String msg = Cast.optionally((Object)instance, HelloWorldActionInstance.class).map(HelloWorldActionInstance::message).orElse("");
        if (world instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)world;
            sl.m_7654_().m_6846_().m_240416_(InstanceHelpers.componentText("Hello from server! Owner " + layer.system.owner + "@" + this.getAnimationPos(layer) + " has finished animation " + layer.getCurrentAnimation().getLocation() + " with message: " + msg), false);
        } else {
            for (Player player : world.m_6907_()) {
                player.m_213846_(InstanceHelpers.componentText("Hello from client! Owner " + layer.system.owner + "@" + this.getAnimationPos(layer) + " has finished animation " + layer.getCurrentAnimation().getLocation() + " with message: " + msg));
            }
        }
    }

    public static class HelloWorldActionInstance
    extends AnimationActionInstance {
        public String message = "";

        public HelloWorldActionInstance(AnimationAction action) {
            super(action);
        }

        public String message() {
            return this.message;
        }

        public HelloWorldActionInstance withMessage(String message) {
            this.message = message;
            return this;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128359_("Msg", this.message);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.message = nbt.m_128461_("Msg");
            super.deserializeNBT(nbt);
        }
    }
}

