/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.client.render.entity.proc;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;
import org.zeith.hammeranims.api.geometry.model.IGeometricModel;
import org.zeith.hammeranims.api.geometry.model.IRenderableBone;
import org.zeith.hammeranims.core.client.render.entity.proc.IProcessor;

public class HeadLookProcessor<T extends LivingEntity>
implements IProcessor<T> {
    private final String headBoneName;

    public HeadLookProcessor(String headBoneName) {
        this.headBoneName = headBoneName;
    }

    @Override
    public void process(T entity, IGeometricModel model, float partialTick) {
        IRenderableBone bone = model.getBone(this.headBoneName);
        if (bone == null) {
            return;
        }
        boolean falling = entity.m_21256_() > 4;
        boolean swimming = entity.m_6067_();
        Vector3f headRot = bone.getRotation();
        float swimAmount = entity.m_20998_(partialTick);
        float headPitch = -Mth.m_14179_((float)partialTick, (float)((LivingEntity)entity).f_19860_, (float)entity.m_146909_());
        boolean shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        float bodyYaw = -Mth.m_14189_((float)partialTick, (float)((LivingEntity)entity).f_20884_, (float)((LivingEntity)entity).f_20883_);
        float headYaw = -Mth.m_14189_((float)partialTick, (float)((LivingEntity)entity).f_20886_, (float)((LivingEntity)entity).f_20885_);
        float netHeadYaw = headYaw - bodyYaw;
        if (shouldSit && entity.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.m_20202_();
            bodyYaw = -Mth.m_14189_((float)partialTick, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            netHeadYaw = headYaw - bodyYaw;
            float wrapped = Mth.m_14177_((float)netHeadYaw);
            if (wrapped < -85.0f) {
                wrapped = -85.0f;
            }
            if (wrapped >= 85.0f) {
                wrapped = 85.0f;
            }
            bodyYaw = headYaw - wrapped;
            if (wrapped * wrapped > 2500.0f) {
                bodyYaw += wrapped * 0.2f;
            }
            netHeadYaw = headYaw - bodyYaw;
        }
        headRot.add(0.0f, (float)Math.PI / 180 * netHeadYaw, 0.0f);
        if (falling) {
            headRot.add(0.7853982f, 0.0f, 0.0f);
        } else if (swimAmount > 0.0f) {
            if (swimming) {
                headRot.add(this.rotlerpRad(swimAmount, headRot.x(), 0.7853982f), 0.0f, 0.0f);
            } else {
                headRot.add(this.rotlerpRad(swimAmount, headRot.x(), (float)Math.PI / 180 * headPitch), 0.0f, 0.0f);
            }
        } else {
            headRot.add((float)Math.PI / 180 * headPitch, 0.0f, 0.0f);
        }
    }

    private float rotlerpRad(float angleIn, float maxAngleIn, float mulIn) {
        float f = (mulIn - maxAngleIn) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngleIn + angleIn * f;
    }
}

