/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.zeith.hammeranims.api.HammerAnimationsApi;
import org.zeith.hammeranims.api.animsys.AnimationSystem;
import org.zeith.hammeranims.api.animsys.IAnimatedObject;
import org.zeith.hammeranims.api.geometry.IGeometryContainer;
import org.zeith.hammeranims.api.geometry.event.RefreshStaleModelsEvent;
import org.zeith.hammeranims.api.geometry.model.GeometryPose;
import org.zeith.hammeranims.api.geometry.model.IGeometricModel;
import org.zeith.hammeranims.api.geometry.model.RenderData;
import org.zeith.hammeranims.core.client.render.entity.proc.CentralModelProcessor;
import org.zeith.hammeranims.core.client.render.entity.proc.IProcessor;

public class BedrockModelWrapper<T extends Entity>
extends EntityModel<T> {
    protected final CentralModelProcessor<T> processor = new CentralModelProcessor();
    protected final IGeometryContainer modelContainer;
    protected IGeometricModel model;
    protected final RenderData renderData = new RenderData();
    public MultiBufferSource buffers;
    public LivingEntity entity;

    public BedrockModelWrapper(Function<ResourceLocation, RenderType> pRenderType, IGeometryContainer geometry) {
        super(pRenderType);
        this.modelContainer = geometry;
        HammerAnimationsApi.EVENT_BUS.addListener(this::refreshGeometry);
    }

    public void addProcessor(IProcessor<? super T> proc) {
        this.processor.add(proc);
    }

    private void refreshGeometry(RefreshStaleModelsEvent e) {
        this.model = this.modelContainer.createModel();
    }

    public void applyAnimSystem(float partialTicks, AnimationSystem system) {
        GeometryPose pose = this.model.emptyPose();
        system.applyAnimation(partialTicks, pose);
        this.model.applyPose(pose);
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.applyAnimSystem(ageInTicks % 1.0f, ((IAnimatedObject)entityIn).getAnimationSystem());
        this.processor.apply(entityIn, this.model, ageInTicks % 1.0f);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderData.apply(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
        this.renderData.red = red;
        this.renderData.green = green;
        this.renderData.blue = blue;
        this.model.renderModel(this.renderData);
    }
}

