/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammeranims.api.geometry.IGeometryContainer;
import org.zeith.hammeranims.core.client.render.entity.BedrockModelWrapper;
import org.zeith.hammeranims.core.client.render.entity.proc.HeadLookProcessor;
import org.zeith.hammeranims.core.client.render.vertex.AccumulatingVertexConsumer;

public abstract class BedrockEntityRenderer<T extends LivingEntity>
extends LivingEntityRenderer<T, BedrockModelWrapper<T>> {
    public BedrockEntityRenderer(EntityRendererProvider.Context pContext, IGeometryContainer geometry, float shadowSize) {
        this(pContext, geometry, shadowSize, new SelfRef());
    }

    private BedrockEntityRenderer(EntityRendererProvider.Context pContext, IGeometryContainer geometry, float shadowSize, SelfRef<T> ref) {
        super(pContext, new BedrockModelWrapper(t -> ref.self.getRenderType((ResourceLocation)t), geometry), shadowSize);
        ref.self = this;
        this.addProcessors((BedrockModelWrapper)this.f_115290_);
    }

    protected List<RenderType> getRenderPasses(T entity) {
        return null;
    }

    protected RenderType getRenderType(ResourceLocation texture) {
        return RenderType.m_110446_((ResourceLocation)texture);
    }

    public void m_7392_(@NotNull T pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        List<RenderType> rp = this.getRenderPasses(pEntity);
        RenderType entType = this.getRenderType(this.m_5478_((Entity)pEntity));
        ArrayList accumulators = rp != null ? new ArrayList() : null;
        MultiBufferSource multiBuffer = rp != null ? type -> {
            if (type == entType) {
                return switch (rp.size()) {
                    case 0 -> VertexMultiConsumer.m_167063_((VertexConsumer[])new VertexConsumer[0]);
                    case 1 -> pBuffer.m_6299_((RenderType)rp.get(0));
                    case 2 -> VertexMultiConsumer.m_86168_((VertexConsumer)AccumulatingVertexConsumer.register(accumulators, (RenderType)rp.get(0)), (VertexConsumer)AccumulatingVertexConsumer.register(accumulators, (RenderType)rp.get(1)));
                    default -> VertexMultiConsumer.m_167063_((VertexConsumer[])((VertexConsumer[])rp.stream().map(t2 -> AccumulatingVertexConsumer.register(accumulators, t2)).toArray(VertexConsumer[]::new)));
                };
            }
            return pBuffer.m_6299_(type);
        } : pBuffer;
        ((BedrockModelWrapper)this.f_115290_).entity = pEntity;
        ((BedrockModelWrapper)this.f_115290_).buffers = multiBuffer;
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, multiBuffer, pPackedLight);
        ((BedrockModelWrapper)this.f_115290_).entity = null;
        ((BedrockModelWrapper)this.f_115290_).buffers = null;
        if (accumulators != null && !accumulators.isEmpty()) {
            for (AccumulatingVertexConsumer.IntoSource src : accumulators) {
                src.applyAndReset(pBuffer);
            }
        }
    }

    protected void m_7523_(@NotNull T pEntityLiving, @NotNull PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.m_7523_(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        pMatrixStack.m_252880_(0.0f, 1.5f, 0.0f);
        pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
    }

    protected void addProcessors(BedrockModelWrapper<T> model) {
        model.addProcessor(new HeadLookProcessor("head"));
    }

    private static class SelfRef<T extends LivingEntity> {
        BedrockEntityRenderer<T> self;

        private SelfRef() {
        }
    }
}

