/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3dc;
import org.zeith.hammeranims.api.animsys.IAnimatedObject;
import org.zeith.hammeranims.api.particles.IParticleContainer;
import org.zeith.hammeranims.api.particles.emitter.ParticleEmitter;
import org.zeith.hammeranims.core.client.particle.ParticleMaterialRenderType;

public class ParticleWithEmitter
extends Particle {
    public static int MAX_EMITTER_GENERATIONS = 6;
    protected final ParticleEmitter emitter;

    public ParticleWithEmitter(ClientLevel worldIn, double posXIn, double posYIn, double posZIn, IParticleContainer container) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.emitter = this.createEmitter(container);
        this.emitter.lastGlobal.set(this.f_107212_, this.f_107213_, this.f_107214_);
        this.emitter.prevGlobal.set((Vector3dc)this.emitter.lastGlobal);
    }

    public ParticleWithEmitter(ClientLevel world, IAnimatedObject object, IParticleContainer container) {
        super(world, object.getAnimatedObjectPosition().f_82479_, object.getAnimatedObjectPosition().f_82480_, object.getAnimatedObjectPosition().f_82481_);
        this.emitter = this.createEmitter(container);
        this.emitter.setTarget(object);
        this.emitter.lastGlobal.set(this.f_107212_, this.f_107213_, this.f_107214_);
        this.emitter.prevGlobal.set((Vector3dc)this.emitter.lastGlobal);
    }

    public ParticleEmitter createEmitter(IParticleContainer container) {
        ParticleEmitter e = new ParticleEmitter();
        e.setEffect(container.getParticleEffect());
        e.setWorld((Level)this.f_107208_);
        return e;
    }

    public void m_5989_() {
        if (this.emitter.generation >= MAX_EMITTER_GENERATIONS) {
            this.f_107220_ = true;
            return;
        }
        this.emitter.prevGlobal.set((Vector3dc)this.emitter.lastGlobal);
        this.emitter.lastGlobal.set(this.f_107212_, this.f_107213_, this.f_107214_);
        this.emitter.update();
        if (this.emitter.lifetime >= 0 && this.emitter.age >= this.emitter.lifetime) {
            this.emitter.running = false;
            this.emitter.stop();
        }
        if (this.emitter.isFinished()) {
            this.f_107220_ = true;
        }
        if (this.emitter.target != null && this.emitter.target.getAnimationSource().get((Level)this.f_107208_) != this.emitter.target) {
            this.f_107220_ = true;
        }
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        Entity viewEntity = pRenderInfo.m_90592_();
        if (this.emitter.isFinished() || viewEntity == null) {
            return;
        }
        Vec3 vector3d = pRenderInfo.m_90583_();
        Vec3 camPos = viewEntity.m_20318_(pPartialTicks);
        Vec3 thirdPersonDelta = camPos.m_82546_(vector3d);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        PoseStack pose = new PoseStack();
        pose.m_85837_(thirdPersonDelta.f_82479_, thirdPersonDelta.f_82480_, thirdPersonDelta.f_82481_);
        this.emitter.render(pRenderInfo, (MultiBufferSource)buffers, pose, pPartialTicks);
        buffers.m_109911_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleMaterialRenderType.BUILTIN[this.emitter.effect.material.ordinal()];
    }

    public boolean shouldCull() {
        return false;
    }

    public void spawn() {
        if (this.emitter.generation >= MAX_EMITTER_GENERATIONS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> mc.f_91061_.m_107344_((Particle)this));
    }

    public ParticleEmitter getEmitter() {
        return this.emitter;
    }
}

