/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.zeith.hammeranims.api.geometry.model.IRenderableBone;
import org.zeith.hammeranims.api.geometry.model.IRenderableHook;
import org.zeith.hammeranims.core.client.model.ModelCubeF;
import org.zeith.hammeranims.core.client.render.IVertexRenderer;
import org.zeith.hammeranims.core.impl.api.geometry.GeometryLocator;

public class ModelBoneF
extends ModelPart
implements IRenderableBone {
    protected ModelBoneF parent;
    public IRenderableHook renderHook = IRenderableHook.NOTHING;
    public final String boxName;
    private final Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    public Vector3f offset = new Vector3f();
    private final Vector3f rotation;
    public Vector3f startRotationRadians;
    private final Map<String, ModelBoneF> children;
    private final Map<String, GeometryLocator> locators;
    public List<ModelCubeF> cubes;
    public boolean renderCubes = true;
    public boolean renderHookAfterCubes = true;
    public boolean renderChildren = true;

    public ModelBoneF(String name, Vector3f startRotRadians, List<ModelCubeF> cubes, Map<String, ModelBoneF> children, Map<String, GeometryLocator> locators, boolean neverRender) {
        super(Collections.emptyList(), Collections.emptyMap());
        this.boxName = name;
        this.startRotationRadians = startRotRadians;
        this.rotation = new Vector3f((Vector3fc)startRotRadians);
        this.f_104207_ = !neverRender;
        this.children = Collections.unmodifiableMap(children);
        this.locators = Collections.unmodifiableMap(locators);
        this.cubes = cubes;
        for (ModelBoneF ch : children.values()) {
            ch.parent = this;
        }
    }

    @Override
    public IRenderableBone getParent() {
        return this.parent;
    }

    @Override
    public void render(PoseStack poseStackIn, IVertexRenderer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_104207_) {
            poseStackIn.m_85836_();
            this.applyBoneTransforms(poseStackIn);
            this.renderCubes(poseStackIn.m_85850_(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            for (ModelBoneF part : this.children.values()) {
                part.render(poseStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            poseStackIn.m_85849_();
        }
    }

    public void m_104299_(PoseStack pPoseStack) {
        this.applyBoneTransforms(pPoseStack);
    }

    @Override
    public void applyBoneTransforms(PoseStack matrixStackIn) {
        matrixStackIn.m_252880_(-this.offset.x() / 16.0f, -this.offset.y() / 16.0f, this.offset.z() / 16.0f);
        matrixStackIn.m_252880_(this.f_104200_ / 16.0f, this.f_104201_ / 16.0f, this.f_104202_ / 16.0f);
        if (this.rotation.x() != 0.0f || this.rotation.y() != 0.0f || this.rotation.z() != 0.0f) {
            matrixStackIn.m_252781_(new Quaternionf().rotateZYX(this.rotation.z(), this.rotation.y(), this.rotation.x()));
        }
        if (this.scale.x() != 1.0f || this.scale.y() != 1.0f || this.scale.z() != 1.0f) {
            matrixStackIn.m_85841_(this.scale.x(), this.scale.y(), this.scale.z());
        }
    }

    @Override
    public void renderCubes(boolean b) {
        this.renderCubes = b;
    }

    @Override
    public void renderHookAfterCubes(boolean b) {
        this.renderHookAfterCubes = b;
    }

    @Override
    public void renderChildren(boolean b) {
        this.renderChildren = b;
    }

    public void renderCubes(PoseStack.Pose matrixEntryIn, IVertexRenderer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.renderCubes) {
            for (ModelCubeF cube : this.cubes) {
                cube.render(matrixEntryIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
        if (this.renderHookAfterCubes) {
            this.renderHook.render(matrixEntryIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }

    @Override
    public String getName() {
        return this.boxName;
    }

    @Override
    public Vector3f getTranslation() {
        return this.offset;
    }

    @Override
    public Vector3f getRotation() {
        return this.rotation;
    }

    @Override
    public Vector3f getScale() {
        return this.scale;
    }

    public Map<String, ModelBoneF> getChildren() {
        return this.children;
    }

    @Override
    public Map<String, GeometryLocator> getLocators() {
        return this.locators;
    }

    @Override
    public void reset() {
        this.renderCubes = true;
        this.renderHookAfterCubes = true;
        this.renderChildren = true;
        this.rotation.set(this.startRotationRadians.x, this.startRotationRadians.y, this.startRotationRadians.z);
        this.offset.set(0.0f, 0.0f, 0.0f);
        this.scale.set(1.0f, 1.0f, 1.0f);
    }
}

