/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.client.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammeranims.api.geometry.constrains.IBoneConstraints;
import org.zeith.hammeranims.api.geometry.constrains.IGeometryConstraints;
import org.zeith.hammeranims.api.geometry.model.GeometryPose;
import org.zeith.hammeranims.api.geometry.model.GeometryTransforms;
import org.zeith.hammeranims.api.geometry.model.IGeometricModel;
import org.zeith.hammeranims.api.geometry.model.IRenderableBone;
import org.zeith.hammeranims.api.geometry.model.RenderData;
import org.zeith.hammeranims.core.client.model.ModelBoneF;
import org.zeith.hammeranims.core.impl.api.geometry.GeometryDataImpl;
import org.zeith.hammeranims.core.impl.api.geometry.GeometryLocator;

public class GeometricModelImpl
implements IGeometricModel {
    protected final ModelBoneF root;
    protected final IGeometryConstraints constraints;
    protected final Map<String, ModelBoneF> bones = new HashMap<String, ModelBoneF>();
    protected final Map<String, IBoneConstraints> boneConstraints = new HashMap<String, IBoneConstraints>();
    protected final Map<String, ModelBoneF> locatorSources = new HashMap<String, ModelBoneF>();
    GeometryPose emptyPose = new GeometryPose(this::hasBone);

    public GeometricModelImpl(GeometryDataImpl root) {
        this.root = root.bakeRoot();
        this.constraints = root.getContainer().getConstraints();
        this.registerBone(this.root);
    }

    protected void registerBone(ModelBoneF part) {
        this.bones.put(part.boxName, part);
        this.boneConstraints.put(part.boxName, this.constraints.getConstraints(part.boxName));
        part.getChildren().values().forEach(this::registerBone);
        for (Map.Entry<String, GeometryLocator> loc : part.getLocators().entrySet()) {
            this.locatorSources.put(loc.getKey(), part);
        }
    }

    @Override
    public Set<String> getBoneNames() {
        return this.bones.keySet();
    }

    @Override
    public IRenderableBone getRoot() {
        return this.root;
    }

    @Override
    public Collection<? extends IRenderableBone> getBones() {
        return this.bones.values();
    }

    @Override
    @Nullable
    public IRenderableBone getBone(String bone) {
        return this.bones.get(bone);
    }

    @Override
    public boolean hasBone(String bone) {
        return this.bones.containsKey(bone);
    }

    @Override
    public void resetPose() {
        for (ModelBoneF s : this.bones.values()) {
            s.reset();
        }
    }

    @Override
    public GeometryPose emptyPose() {
        this.emptyPose.reset();
        return this.emptyPose;
    }

    @Override
    public void applyPose(GeometryPose pose) {
        Map<String, GeometryTransforms> poseBones = pose.getBoneTransforms();
        for (String boneKey : this.bones.keySet()) {
            ModelBoneF bone = this.bones.get(boneKey);
            if (bone == null) continue;
            bone.reset();
            GeometryTransforms add = poseBones.get(boneKey);
            if (add == null) continue;
            add.applyConstraints(this.boneConstraints.get(boneKey));
            Vec3 translate = add.translation;
            Vec3 rotate = add.rotation.m_82490_(0.01745329238474369);
            Vec3 scale = add.scale;
            bone.offset.add((float)translate.f_82479_, (float)(-translate.f_82480_), (float)translate.f_82481_);
            bone.getRotation().sub((float)rotate.f_82479_, (float)rotate.f_82480_, (float)(-rotate.f_82481_));
            bone.getScale().mul((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModel(RenderData data) {
        this.root.render(data.pose, data.getOutput(), data.lighting, data.overlay, data.red, data.green, data.blue, data.alpha);
    }

    @Override
    public void dispose() {
    }
}

