/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.client.model;

import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.zeith.hammeranims.core.impl.api.geometry.decoder.UVDefinition;
import org.zeith.hammeranims.core.utils.EnumFacing;

public interface CubeUVs {
    @Nullable
    public SizedUV get(EnumFacing var1);

    public static class SizedUV {
        private final int u1;
        private final int v1;
        private final int u2;
        private final int v2;

        public SizedUV(int u1, int v1, int u2, int v2) {
            this.u1 = u1;
            this.v1 = v1;
            this.u2 = u2;
            this.v2 = v2;
        }

        public int u1() {
            return this.u1;
        }

        public int v1() {
            return this.v1;
        }

        public int u2() {
            return this.u2;
        }

        public int v2() {
            return this.v2;
        }

        public static SizedUV fromFloats(float u1, float v1, float u2, float v2) {
            return new SizedUV((int)Math.ceil(u1), (int)Math.ceil(v1), (int)Math.ceil(u2), (int)Math.ceil(v2));
        }
    }

    public static class FacedUVResolver
    implements CubeUVs {
        private final Map<EnumFacing, UVDefinition.FaceUVDefinition> mappings;

        public FacedUVResolver(Map<EnumFacing, UVDefinition.FaceUVDefinition> mappings) {
            this.mappings = mappings;
        }

        @Override
        public SizedUV get(EnumFacing direction) {
            UVDefinition.FaceUVDefinition uvDefinition = this.mappings.get((Object)direction);
            if (uvDefinition == null) {
                return null;
            }
            return new SizedUV(uvDefinition.uv().x(), uvDefinition.uv().y(), uvDefinition.uv().x() + uvDefinition.size().x(), uvDefinition.uv().y() + uvDefinition.size().y());
        }
    }

    public static class BoxUVResolver
    implements CubeUVs {
        private final Vector2i uv;
        private final Vector3f size;

        public BoxUVResolver(Vector2i uv, Vector3f size) {
            this.uv = uv;
            this.size = size;
        }

        @Override
        public SizedUV get(EnumFacing direction) {
            return switch (direction) {
                case EnumFacing.EAST -> SizedUV.fromFloats(this.uv.x(), this.uv.y() + this.depth(), this.uv.x() + this.depth(), this.uv.y() + this.depth() + this.height());
                case EnumFacing.WEST -> SizedUV.fromFloats(this.uv.x() + this.depth() + this.width(), this.uv.y() + this.depth(), this.uv.x() + this.depth() + this.width() + this.depth(), this.uv.y() + this.depth() + this.height());
                case EnumFacing.DOWN -> SizedUV.fromFloats(this.uv.x() + this.depth() + this.width(), this.uv.y() + this.depth(), this.uv.x() + this.depth() + this.width() + this.width(), this.uv.y());
                case EnumFacing.UP -> SizedUV.fromFloats(this.uv.x() + this.depth(), this.uv.y(), this.uv.x() + this.depth() + this.width(), this.uv.y() + this.depth());
                case EnumFacing.NORTH -> SizedUV.fromFloats(this.uv.x() + this.depth(), this.uv.y() + this.depth(), this.uv.x() + this.depth() + this.width(), this.uv.y() + this.depth() + this.height());
                case EnumFacing.SOUTH -> SizedUV.fromFloats(this.uv.x() + this.depth() + this.width() + this.depth(), this.uv.y() + this.depth(), this.uv.x() + this.depth() + this.width() + this.depth() + this.width(), this.uv.y() + this.depth() + this.height());
                default -> throw new IllegalStateException("Wtf?");
            };
        }

        public int width() {
            return (int)this.size.x();
        }

        public int height() {
            return (int)this.size.y();
        }

        public int depth() {
            return (int)this.size.z();
        }
    }
}

