/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.core.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.zeith.hammeranims.HammerAnimations;
import org.zeith.hammeranims.api.animsys.AnimationSystem;
import org.zeith.hammeranims.api.animsys.IAnimatedObject;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.tuples.Tuple3;
import org.zeith.hammerlib.util.java.tuples.Tuples;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientHammerHooks {
    private static final List<Tuple3.Mutable3<IObjectSource<?>, CompoundTag, Integer>> QUEUED_SYSTEMS = new ArrayList();

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            return;
        }
        ClientLevel w = Minecraft.m_91087_().f_91073_;
        if (w == null) {
            QUEUED_SYSTEMS.clear();
            return;
        }
        QUEUED_SYSTEMS.removeIf(src -> {
            int ticksAwaiting = (Integer)src.c();
            src.setC((Object)(ticksAwaiting - 1));
            if (ticksAwaiting <= 0) {
                HammerAnimations.LOG.warn("Animation update for {} has timed out.", src.a());
                return true;
            }
            return ClientHammerHooks.applyAnimationSystem((Level)w, (IObjectSource)src.a(), (CompoundTag)src.b());
        });
    }

    public static void applySystem(IObjectSource<?> source, CompoundTag tag, int timeout) {
        if (source == null || tag == null) {
            HammerAnimations.LOG.error("Completely ignored animation sync with {} or {} being null.", source, (Object)tag);
            return;
        }
        if (!ClientHammerHooks.applyAnimationSystem((Level)Minecraft.m_91087_().f_91073_, source, tag)) {
            QUEUED_SYSTEMS.add(Tuples.mutable(source, (Object)tag, (Object)timeout));
        }
    }

    private static boolean applyAnimationSystem(Level world, IObjectSource<?> source, CompoundTag tag) {
        IAnimatedObject obj = (IAnimatedObject)Cast.cast((Object)source.get(world), IAnimatedObject.class);
        if (obj == null) {
            return false;
        }
        AnimationSystem sys = obj.getAnimationSystem();
        if (sys == null) {
            return true;
        }
        sys.deserializeNBT(tag);
        return true;
    }
}

