/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammeranims.api.utils;

import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

@FunctionalInterface
public interface IResourceProvider {
    public Optional<byte[]> read(ResourceLocation var1);

    default public Optional<String> readAsString(ResourceLocation path) {
        return this.read(path).map(String::new);
    }

    public static IResourceProvider or(List<IResourceProvider> resources) {
        return path -> {
            Optional<Object> read = Optional.empty();
            for (IResourceProvider resource : resources) {
                read = resource.read(path);
                if (!read.isPresent()) continue;
                return read;
            }
            return read;
        };
    }
}

